/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.typehandler.markdown;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.fugerit.java.doc.base.config.DocInput;
import org.fugerit.java.doc.base.config.DocOutput;
import org.fugerit.java.doc.base.config.DocTypeHandler;
import org.fugerit.java.doc.base.model.DocBase;
import org.fugerit.java.doc.base.typehandler.markdown.AbstractCustomMarkdownTypeHandler;
import org.fugerit.java.doc.base.typehandler.markdown.MarkdownExtDocFacade;

public class SimpleMarkdownExtTypeHandler
extends AbstractCustomMarkdownTypeHandler {
    public static final DocTypeHandler HANDLER = new SimpleMarkdownExtTypeHandler();
    public static final DocTypeHandler HANDLER_NOCOMMENTS = new SimpleMarkdownExtTypeHandler(false);
    public static final DocTypeHandler HANDLER_UTF8 = new SimpleMarkdownExtTypeHandler(StandardCharsets.UTF_8);
    public static final DocTypeHandler HANDLER_NOCOMMENTS_UTF8 = new SimpleMarkdownExtTypeHandler(StandardCharsets.UTF_8, false);
    private static final long serialVersionUID = -7394541608L;

    public SimpleMarkdownExtTypeHandler() {
    }

    public SimpleMarkdownExtTypeHandler(boolean printComments) {
        super(printComments);
    }

    public SimpleMarkdownExtTypeHandler(Charset charset, boolean printComments) {
        super(charset, printComments);
    }

    public SimpleMarkdownExtTypeHandler(Charset charset) {
        super(charset);
    }

    @Override
    public void handle(DocInput docInput, DocOutput docOutput) throws Exception {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(docOutput.getOs(), this.getCharset()));
        DocBase docBase = docInput.getDoc();
        MarkdownExtDocFacade facade = new MarkdownExtDocFacade(writer, this.isPrintComments());
        facade.handleDoc(docBase);
    }
}

