/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.parser;

import java.util.LinkedList;
import java.util.Properties;
import org.fugerit.java.core.cfg.ConfigRuntimeException;
import org.fugerit.java.core.lang.helpers.BooleanUtils;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.doc.base.model.DocBackground;
import org.fugerit.java.doc.base.model.DocBarcode;
import org.fugerit.java.doc.base.model.DocBase;
import org.fugerit.java.doc.base.model.DocBookmark;
import org.fugerit.java.doc.base.model.DocBookmarkTree;
import org.fugerit.java.doc.base.model.DocBorders;
import org.fugerit.java.doc.base.model.DocBr;
import org.fugerit.java.doc.base.model.DocCell;
import org.fugerit.java.doc.base.model.DocContainer;
import org.fugerit.java.doc.base.model.DocElement;
import org.fugerit.java.doc.base.model.DocFooter;
import org.fugerit.java.doc.base.model.DocHeader;
import org.fugerit.java.doc.base.model.DocHeaderFooter;
import org.fugerit.java.doc.base.model.DocImage;
import org.fugerit.java.doc.base.model.DocInfo;
import org.fugerit.java.doc.base.model.DocLi;
import org.fugerit.java.doc.base.model.DocList;
import org.fugerit.java.doc.base.model.DocNbsp;
import org.fugerit.java.doc.base.model.DocPageBreak;
import org.fugerit.java.doc.base.model.DocPara;
import org.fugerit.java.doc.base.model.DocPhrase;
import org.fugerit.java.doc.base.model.DocRow;
import org.fugerit.java.doc.base.model.DocTable;
import org.fugerit.java.doc.base.parser.DocParserHelper;
import org.fugerit.java.doc.base.parser.DocParserNameCheck;
import org.fugerit.java.doc.base.xml.DocStyleAlignHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocParserContext {
    private static final Logger log = LoggerFactory.getLogger(DocParserContext.class);
    private static final boolean FAIL_WHEN_ELEMENT_NOT_FOUND = false;
    private static final String XSD_URL_BASE = "www.fugerit.org/data/java/doc/xsd/doc-";
    private static final String XSD_BASE = "http://javacoredoc.fugerit.org https://www.fugerit.org/data/java/doc/xsd/doc-";
    private DocParserHelper parserHelper = DocParserHelper.getInstance();
    private DocParserNameCheck parserNames = DocParserNameCheck.getInstance();
    private DocBase docBase;
    private DocElement currentElement;
    private DocContainer currentContainer;
    private Properties infos;
    private LinkedList<DocContainer> parents;

    public static String findXsdVersion(Properties props) {
        String xsdVersion = null;
        for (Object key : props.keySet()) {
            String value;
            int xsdBaseIndex;
            String k = String.valueOf(key);
            if (!k.contains("schemaLocation") || (xsdBaseIndex = (value = props.getProperty(k)).indexOf(XSD_URL_BASE)) == -1) continue;
            xsdVersion = value.substring(xsdBaseIndex + XSD_URL_BASE.length(), value.length() - 4);
        }
        return xsdVersion;
    }

    public static String createXsdVersionXmlns(String xsdVersion) {
        return XSD_BASE + xsdVersion + ".xsd";
    }

    public DocBase getDocBase() {
        return this.docBase;
    }

    public void startDocument() {
        this.parents = new LinkedList();
        this.currentContainer = null;
        this.currentElement = null;
        this.infos = new Properties();
    }

    public void endDocument() {
        if (this.infos.size() != this.docBase.getInfo().size()) {
            throw new ConfigRuntimeException("Parsing error, wrong info size : " + this.infos.size());
        }
        this.docBase.setStableInfo(this.infos);
        log.debug("info {}", (Object)this.infos);
    }

    public void handleText(String text) {
        if (text.trim().length() > 0 && this.currentElement instanceof DocPhrase) {
            DocPhrase docPhrase = (DocPhrase)this.currentElement;
            docPhrase.setText(docPhrase.getText() + text);
        } else if (text.trim().length() > 0 && this.currentElement instanceof DocPara) {
            DocPara docPara = (DocPara)this.currentElement;
            docPara.setText(docPara.getText() + text);
        } else if (text.trim().length() > 0 && this.currentElement instanceof DocBookmark) {
            DocBookmark docBookmarkTitle = (DocBookmark)this.currentElement;
            docBookmarkTitle.setTitle(docBookmarkTitle.getTitle() + text);
        } else if (text.trim().length() > 0 && this.currentElement instanceof DocInfo) {
            DocInfo docInfo = (DocInfo)this.currentElement;
            docInfo.getContent().append(text);
        }
    }

    public void handleEndElement(String qName) {
        if ("info".equals(qName)) {
            DocInfo docInfo = (DocInfo)this.currentElement;
            this.infos.setProperty(docInfo.getName(), docInfo.getContent().toString());
        }
        if (this.parserHelper.isContainerElement(qName)) {
            this.currentContainer = !this.parents.isEmpty() ? this.parents.remove(this.parents.size() - 1) : null;
        }
    }

    private void handleStartDoc(Properties props) {
        this.docBase = new DocBase();
        String xsdVersion = DocParserContext.findXsdVersion(props);
        this.docBase.setXsdVersion(xsdVersion);
    }

    private void handleStartMeta() {
        DocContainer docMeta = this.docBase.getDocMeta();
        this.currentElement = docMeta;
    }

    private void handleStartInfo(Properties props) {
        DocInfo docInfo = new DocInfo();
        docInfo.setName(props.getProperty("name"));
        this.currentElement = docInfo;
    }

    private void handleStartHeader(String qName, Properties props) {
        DocHeader docHeader = this.docBase.getDocHeader();
        DocParserContext.handleHeaderFooter(docHeader, props);
        docHeader.setUseHeader(true);
        docHeader.setBasic("header".equalsIgnoreCase(qName));
        this.currentElement = docHeader;
    }

    private void handleStartFooter(String qName, Properties props) {
        DocFooter docFooter = this.docBase.getDocFooter();
        DocParserContext.handleHeaderFooter(docFooter, props);
        docFooter.setUseFooter(true);
        docFooter.setBasic("footer".equalsIgnoreCase(qName));
        this.currentElement = docFooter;
    }

    private void handleStartBackground() {
        DocBackground docBackground = new DocBackground();
        this.docBase.setDocBackground(docBackground);
        this.currentElement = docBackground;
    }

    private void handleStartBody() {
        DocContainer docBody = this.docBase.getDocBody();
        this.currentElement = docBody;
    }

    private void handleStartImage(Properties props) {
        String alt;
        String type;
        DocImage docImage = new DocImage();
        String url = props.getProperty("url");
        docImage.setUrl(url);
        String scaling = props.getProperty("scaling");
        if (scaling != null) {
            docImage.setScaling(Integer.valueOf(scaling));
        } else {
            docImage.setScaling(null);
        }
        String base64 = props.getProperty("base64");
        if (StringUtils.isNotEmpty((String)base64)) {
            docImage.setBase64(base64);
        }
        if (StringUtils.isNotEmpty((String)(type = props.getProperty("type")))) {
            docImage.setType(type);
        }
        if (StringUtils.isNotEmpty((String)(alt = props.getProperty("alt")))) {
            docImage.setAlt(alt);
        }
        String align = props.getProperty("align");
        docImage.setAlign(DocStyleAlignHelper.getAlign(align));
        this.currentElement = docImage;
    }

    private void handleStartTable(Properties props) {
        DocTable docTable = new DocTable();
        docTable.setColumns(Integer.parseInt(props.getProperty("columns")));
        docTable.setWidth(Integer.parseInt(props.getProperty("width", "-1")));
        docTable.setBackColor(props.getProperty("back-color"));
        docTable.setForeColor(props.getProperty("fore-color"));
        docTable.setAlt(props.getProperty("alt"));
        docTable.setSpacing(Integer.parseInt(props.getProperty("spacing", this.infos.getProperty("default-table-spacing", "0"))));
        docTable.setPadding(Integer.parseInt(props.getProperty("padding", this.infos.getProperty("default-table-padding", "0"))));
        docTable.setRenderMode(props.getProperty("render-mode", "normal"));
        String cols = props.getProperty("colwidths");
        if (cols != null) {
            String[] colsParsed = cols.split(";");
            int[] withds = new int[colsParsed.length];
            for (int k = 0; k < withds.length; ++k) {
                withds[k] = Integer.parseInt(colsParsed[k]);
            }
            docTable.setColWithds(withds);
        }
        String spaceBefore = props.getProperty("space-before");
        String spaceAfter = props.getProperty("space-after");
        if (spaceBefore != null) {
            docTable.setSpaceBefore(Float.valueOf(spaceBefore));
        }
        if (spaceAfter != null) {
            docTable.setSpaceAfter(Float.valueOf(spaceAfter));
        }
        this.currentElement = docTable;
    }

    private void handleStartRow(Properties props) {
        DocRow docRow = new DocRow();
        docRow.setHeader(BooleanUtils.isTrue((String)props.getProperty("header")));
        this.currentElement = docRow;
    }

    private void handleStartCell(Properties props) {
        DocCell docCell = new DocCell();
        docCell.setCSpan(Integer.parseInt(props.getProperty("colspan", "1")));
        docCell.setRSpan(Integer.parseInt(props.getProperty("rowspan", "1")));
        docCell.setBackColor(props.getProperty("back-color"));
        docCell.setForeColor(props.getProperty("fore-color"));
        docCell.setType(props.getProperty("type"));
        docCell.setHeader("true".equalsIgnoreCase(props.getProperty("header")));
        String align = props.getProperty("align");
        docCell.setAlign(DocStyleAlignHelper.getAlign(align));
        String valign = props.getProperty("valign");
        docCell.setValign(DocStyleAlignHelper.getValign(valign));
        docCell.setDocBorders(DocBorders.createBorders(props, this.infos.getProperty("default-cell-border-width", "-1")));
        this.currentElement = docCell;
    }

    private void handleStartPl() {
        DocContainer container = new DocContainer();
        this.currentElement = container;
    }

    private void handleStartPara(Properties props) {
        DocPara docPara = new DocPara();
        DocParserContext.valuePara(docPara, props, false);
        this.currentElement = docPara;
    }

    private void handleStartH(Properties props) {
        DocPara docPara = new DocPara();
        DocParserContext.valuePara(docPara, props, true);
        this.currentElement = docPara;
    }

    private void handleStartBr(Properties props) {
        DocBr docBr = new DocBr();
        DocParserContext.valuePhrase(docBr, props);
        docBr.setText("\n");
        this.currentElement = docBr;
    }

    private void handleStartNbsp(Properties props) {
        DocNbsp docNbsp = new DocNbsp();
        DocParserContext.valuePhrase(docNbsp, props);
        int length = Integer.parseInt(props.getProperty("length", "2"));
        docNbsp.setLength(length);
        this.currentElement = docNbsp;
    }

    private void handleStartPhrase(Properties props) {
        DocPhrase docPhrase = new DocPhrase();
        DocParserContext.valuePhrase(docPhrase, props);
        this.currentElement = docPhrase;
    }

    private void handleStartBarcode(Properties props) {
        DocBarcode barcode = new DocBarcode();
        barcode.setSize(Integer.parseInt(props.getProperty("size", "-1")));
        barcode.setType(props.getProperty("type", "EAN"));
        barcode.setText(props.getProperty("text"));
        this.currentElement = barcode;
    }

    private void handleStartList(Properties props) {
        DocList docList = new DocList();
        String listType = props.getProperty("list-type", "ol");
        docList.setListType(listType);
        this.currentElement = docList;
    }

    private void handleStartLi() {
        DocLi docLi = new DocLi();
        this.currentElement = docLi;
    }

    private void handleStartPageBreak() {
        this.currentElement = new DocPageBreak();
    }

    private void handleStartBookmarkTree() {
        DocBookmarkTree docBookmarkTree = new DocBookmarkTree();
        this.docBase.setDocBookmarkTree(docBookmarkTree);
        this.currentElement = docBookmarkTree;
    }

    private void handleStartBookmark(Properties props) {
        DocBookmark docBookmark = new DocBookmark();
        String ref = props.getProperty("ref");
        docBookmark.setRef(ref);
        this.currentElement = docBookmark;
    }

    private void handleStartFinalJob(String qName, Properties props) {
        String id;
        if (this.currentContainer != null && this.currentContainer != this.currentElement) {
            this.currentContainer.addElement(this.currentElement);
        }
        if (this.parserHelper.isContainerElement(qName)) {
            this.parents.add(this.currentContainer);
            this.currentContainer = (DocContainer)this.currentElement;
        }
        if ((id = props.getProperty("id")) != null) {
            this.docBase.setId(id, this.currentElement);
        }
    }

    private boolean handleStartElementPriorityOne(String qName, Properties props) {
        boolean ok = false;
        if ("para".equalsIgnoreCase(qName)) {
            this.handleStartPara(props);
            ok = true;
        } else if ("h".equalsIgnoreCase(qName)) {
            this.handleStartH(props);
            ok = true;
        } else if ("phrase".equalsIgnoreCase(qName)) {
            this.handleStartPhrase(props);
            ok = true;
        } else if ("list".equalsIgnoreCase(qName)) {
            this.handleStartList(props);
            ok = true;
        } else if ("li".equalsIgnoreCase(qName)) {
            this.handleStartLi();
            ok = true;
        } else if ("table".equalsIgnoreCase(qName)) {
            this.handleStartTable(props);
            ok = true;
        } else if ("row".equalsIgnoreCase(qName)) {
            this.handleStartRow(props);
            ok = true;
        } else if ("cell".equalsIgnoreCase(qName)) {
            this.handleStartCell(props);
            ok = true;
        } else if ("page-break".equalsIgnoreCase(qName)) {
            this.handleStartPageBreak();
            ok = true;
        }
        return ok;
    }

    private boolean handleStartElementPriorityTwo(String qName, Properties props) {
        boolean ok = false;
        if (this.parserNames.isTypeDoc(qName)) {
            this.handleStartDoc(props);
            ok = true;
        } else if ("meta".equalsIgnoreCase(qName) || "metadata".equalsIgnoreCase(qName)) {
            this.handleStartMeta();
            ok = true;
        } else if ("body".equalsIgnoreCase(qName)) {
            this.handleStartBody();
            ok = true;
        } else if ("info".equalsIgnoreCase(qName)) {
            this.handleStartInfo(props);
            ok = true;
        } else if ("header".equalsIgnoreCase(qName) || "header-ext".equalsIgnoreCase(qName)) {
            this.handleStartHeader(qName, props);
            ok = true;
        } else if ("footer".equalsIgnoreCase(qName) || "footer-ext".equalsIgnoreCase(qName)) {
            this.handleStartFooter(qName, props);
            ok = true;
        } else if ("br".equalsIgnoreCase(qName)) {
            this.handleStartBr(props);
            ok = true;
        } else if ("nbsp".equalsIgnoreCase(qName)) {
            this.handleStartNbsp(props);
            ok = true;
        }
        return ok;
    }

    private boolean handleStartElementPriorityThree(String qName, Properties props) {
        boolean ok = false;
        if ("background".equalsIgnoreCase(qName)) {
            this.handleStartBackground();
            ok = true;
        } else if ("image".equalsIgnoreCase(qName)) {
            this.handleStartImage(props);
            ok = true;
        } else if ("pl".equalsIgnoreCase(qName)) {
            this.handleStartPl();
            ok = true;
        } else if ("barcode".equalsIgnoreCase(qName)) {
            this.handleStartBarcode(props);
            ok = true;
        } else if ("bookmark-tree".equalsIgnoreCase(qName)) {
            this.handleStartBookmarkTree();
            ok = true;
        } else if ("bookmark".equalsIgnoreCase(qName)) {
            this.handleStartBookmark(props);
            ok = true;
        }
        return ok;
    }

    public void handleStartElement(String qName, Properties props) {
        boolean ok = this.handleStartElementPriorityOne(qName, props);
        if (!(ok || (ok = this.handleStartElementPriorityTwo(qName, props)) || (ok = this.handleStartElementPriorityThree(qName, props)))) {
            String message = "Element not found : " + qName;
            log.warn(message);
        }
        this.handleStartFinalJob(qName, props);
    }

    private static void handleHeaderFooter(DocHeaderFooter headerFooter, Properties atts) {
        String align = atts.getProperty("align");
        headerFooter.setAlign(DocStyleAlignHelper.getAlign(align));
        String numbered = atts.getProperty("numbered");
        headerFooter.setNumbered(BooleanUtils.isTrue((String)numbered));
        String borderWidth = atts.getProperty("border-width", "0");
        headerFooter.setBorderWidth(Integer.parseInt(borderWidth));
        String exepectedSize = atts.getProperty("expected-size", "15");
        headerFooter.setExpectedSize(Integer.parseInt(exepectedSize));
    }

    private static void valuePhrase(DocPhrase docPhrase, Properties props) {
        String whiteSpaceCollapse;
        String anchor;
        String link;
        docPhrase.setSize(Integer.parseInt(props.getProperty("size", "-1")));
        String style = props.getProperty("style");
        docPhrase.setStyle(DocPara.parseStyle(style));
        docPhrase.setOriginalStyle(DocPara.parseStyle(style, -1));
        String fontName = props.getProperty("font-name");
        docPhrase.setFontName(fontName);
        String leading = props.getProperty("leading");
        if (leading != null) {
            docPhrase.setLeading(Float.valueOf(leading));
        }
        if ((link = props.getProperty("link")) != null) {
            docPhrase.setLink(link);
        }
        if ((anchor = props.getProperty("anchor")) != null) {
            docPhrase.setAnchor(anchor);
        }
        if (StringUtils.isNotEmpty((String)(whiteSpaceCollapse = props.getProperty("white-space-collapse")))) {
            docPhrase.setWhiteSpaceCollapse(whiteSpaceCollapse);
        }
    }

    private static void valuePara(DocPara docPara, Properties props, boolean headings) {
        String style = props.getProperty("style");
        int defaultStyle = 1;
        if (headings) {
            defaultStyle = 2;
        }
        docPara.setStyle(DocPara.parseStyle(style, defaultStyle));
        docPara.setOriginalStyle(DocPara.parseStyle(style, -1));
        String id = props.getProperty("id");
        docPara.setId(id);
        String align = props.getProperty("align");
        docPara.setAlign(DocStyleAlignHelper.getAlign(align));
        String fontName = props.getProperty("font-name");
        docPara.setFontName(fontName);
        String leading = props.getProperty("leading");
        docPara.setBackColor(props.getProperty("back-color"));
        docPara.setForeColor(props.getProperty("fore-color"));
        docPara.setFormat(props.getProperty("format"));
        docPara.setType(props.getProperty("type"));
        if (leading != null) {
            docPara.setLeading(Float.valueOf(leading));
        }
        docPara.setSize(Integer.parseInt(props.getProperty("size", "-1")));
        String textIndent = props.getProperty("text-indent");
        String spaceBefore = props.getProperty("space-before");
        String spaceAfter = props.getProperty("space-after");
        String spaceLeft = props.getProperty("space-left");
        String spaceRight = props.getProperty("space-right");
        if (textIndent != null) {
            docPara.setTextIndent(Float.valueOf(textIndent));
        }
        if (spaceBefore != null) {
            docPara.setSpaceBefore(Float.valueOf(spaceBefore));
        }
        if (spaceAfter != null) {
            docPara.setSpaceAfter(Float.valueOf(spaceAfter));
        }
        if (spaceLeft != null) {
            docPara.setSpaceLeft(Float.valueOf(spaceLeft));
        }
        if (spaceRight != null) {
            docPara.setSpaceRight(Float.valueOf(spaceRight));
        }
        docPara.setHeadLevel(Integer.parseInt(props.getProperty("head-level", String.valueOf(0))));
        String whiteSpaceCollapse = props.getProperty("white-space-collapse");
        if (StringUtils.isNotEmpty((String)whiteSpaceCollapse)) {
            docPara.setWhiteSpaceCollapse(whiteSpaceCollapse);
        }
    }
}

