/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.facade;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.Properties;
import org.fugerit.java.core.cfg.ConfigRuntimeException;
import org.fugerit.java.core.io.helper.StreamHelper;
import org.fugerit.java.core.lang.helpers.BooleanUtils;
import org.fugerit.java.core.log.LogFacade;
import org.fugerit.java.core.util.ObjectUtils;
import org.fugerit.java.doc.base.config.DocException;
import org.fugerit.java.doc.base.config.DocVersion;
import org.fugerit.java.doc.base.model.DocBase;
import org.fugerit.java.doc.base.model.DocContainer;
import org.fugerit.java.doc.base.model.DocElement;
import org.fugerit.java.doc.base.model.DocHelper;
import org.fugerit.java.doc.base.xml.DocXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocFacade {
    private static final Logger log = LoggerFactory.getLogger(DocFacade.class);
    public static final String CURRENT_VERSION = DocVersion.CURRENT_VERSION.stringVersion();
    public static final String PARAM_KEY_CLOSE_STREAM = "close-stream";
    public static final String PARAM_VALUE_CLOSE_STREAM_DEFAULT = "1";
    private static final Properties DEFAULT_PARAMS = new Properties();
    public static final String PARAM_DEFINITION_MODE = "definition-mode";
    public static final String PARAM_DEFINITION_MODE_XSD = "xsd";
    public static final String PARAM_DEFINITION_MODE_DTD = "dtd";
    public static final String PARAM_DEFINITION_MODE_DEFAULT = "xsd";
    public static final String SYSTEM_ID = "http://javacoredoc.fugerit.org";

    private DocFacade() {
    }

    private static void print(PrintStream s, DocContainer docContainer, String indent) {
        Iterator<DocElement> it = docContainer.docElements();
        while (it.hasNext()) {
            DocElement docElement = it.next();
            s.println(indent + docElement);
            if (!(docElement instanceof DocContainer)) continue;
            DocFacade.print(s, (DocContainer)docElement, indent + "  ");
        }
    }

    private static void print(PrintStream s, DocContainer docContainer) {
        DocFacade.print(s, docContainer, "");
    }

    public static void print(PrintStream s, DocBase doc) {
        DocFacade.print(s, doc.getDocBody());
    }

    public static boolean validate(Reader is) throws DocException {
        return DocFacade.validate(is, DEFAULT_PARAMS);
    }

    public static boolean validate(Reader is, Properties params) throws DocException {
        boolean valRes = false;
        try {
            params = (Properties)ObjectUtils.objectWithDefault((Object)params, (Object)DEFAULT_PARAMS);
            DocXmlParser parser = new DocXmlParser(DocHelper.DEFAULT);
            int result = parser.validate(is);
            valRes = result == 0;
        }
        catch (Exception e) {
            throw DocException.convertExMethod("validate", e);
        }
        finally {
            if (BooleanUtils.isTrue((String)params.getProperty(PARAM_KEY_CLOSE_STREAM, PARAM_VALUE_CLOSE_STREAM_DEFAULT))) {
                StreamHelper.closeSafe((Reader)is);
            }
        }
        return valRes;
    }

    public static DocBase parse(Reader is, DocHelper docHelper) throws DocException {
        return DocFacade.parse(is, docHelper, DEFAULT_PARAMS);
    }

    public static DocBase parse(Reader is, DocHelper docHelper, Properties params) throws DocException {
        DocBase docBase = null;
        try {
            LogFacade.getLog().warn("parse() method with DocHelper parameter should be avoided , as currently supported, param value : {}", (Object)docHelper);
            params = (Properties)ObjectUtils.objectWithDefault((Object)params, (Object)DEFAULT_PARAMS);
            DocXmlParser parser = new DocXmlParser(DocHelper.DEFAULT);
            docBase = parser.parse(is);
        }
        catch (Exception e) {
            throw DocException.convertExMethod("parse", e);
        }
        finally {
            if (BooleanUtils.isTrue((String)params.getProperty(PARAM_KEY_CLOSE_STREAM, PARAM_VALUE_CLOSE_STREAM_DEFAULT))) {
                StreamHelper.closeSafe((Reader)is);
            }
        }
        return docBase;
    }

    public static DocBase parse(InputStream is, DocHelper docHelper, Properties params) throws DocException {
        return DocFacade.parse(new InputStreamReader(is), docHelper, params);
    }

    public static DocBase parse(Reader is) throws DocException {
        return DocFacade.parse(is, DocHelper.DEFAULT, DEFAULT_PARAMS);
    }

    public static DocBase parseRE(Reader is, int sourceType) {
        DocBase doc = null;
        try {
            log.debug("sourceType : {}", (Object)sourceType);
            doc = DocFacade.parse(is, DocHelper.DEFAULT, DEFAULT_PARAMS);
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("Exception on parseRE : " + e, (Throwable)e);
        }
        return doc;
    }

    public static DocBase parseRE(Reader is) {
        DocBase doc = null;
        try {
            doc = DocFacade.parse(is, DocHelper.DEFAULT, DEFAULT_PARAMS);
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("Exception on parseRE : " + e, (Throwable)e);
        }
        return doc;
    }

    public static DocBase parse(InputStream is) throws DocException {
        return DocFacade.parse(is, DocHelper.DEFAULT, DEFAULT_PARAMS);
    }
}

