/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.config;

import java.io.Reader;
import org.fugerit.java.doc.base.facade.DocFacadeSource;
import org.fugerit.java.doc.base.model.DocBase;

public class DocInput {
    private String type;
    private DocBase doc;
    private Reader reader;
    private int source;

    public Reader getReader() {
        return this.reader;
    }

    public String getType() {
        return this.type;
    }

    public DocBase getDoc() {
        DocBase res = this.doc;
        if (res == null && this.reader != null) {
            res = DocFacadeSource.getInstance().parseRE(this.reader, this.getSource());
        }
        return res;
    }

    public int getSource() {
        return this.source;
    }

    public DocInput(String type, DocBase doc, Reader reader) {
        this(type, doc, reader, 1);
    }

    public DocInput(String type, DocBase doc, Reader reader, int source) {
        this.type = type;
        this.reader = reader;
        this.doc = doc;
        this.source = source;
    }

    public static DocInput newInput(String type, DocBase doc) {
        return DocInput.newInput(type, doc, null);
    }

    public static DocInput newInput(String type, Reader reader) {
        return DocInput.newInput(type, null, reader);
    }

    public static DocInput newInput(String type, DocBase doc, Reader reader) {
        return DocInput.newInput(type, doc, reader, 1);
    }

    public static DocInput newInput(String type, Reader reader, int source) {
        return DocInput.newInput(type, null, reader, source);
    }

    public static DocInput newInput(String type, DocBase doc, Reader reader, int source) {
        return new DocInput(type, doc, reader, source);
    }
}

