/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import java.util.concurrent.TimeUnit;

public interface EventKeeper {
    public void count(Event var1, long var2);

    default public void increment(Event event) {
        this.count(event, 1L);
    }

    public void timeNanos(Event var1, long var2);

    default public void time(Event event, long l, TimeUnit timeUnit) {
        this.timeNanos(event, timeUnit.toNanos(l));
    }

    public long getCount(Event var1);

    public long getTimeNanos(Event var1);

    default public long getTime(Event event, TimeUnit timeUnit) {
        return timeUnit.convert(this.getTimeNanos(event), TimeUnit.NANOSECONDS);
    }

    public static interface Event {
        public String name();

        default public boolean isTimeEvent() {
            return false;
        }
    }

    public static enum Events implements Event
    {
        JNI_CALL,
        BYTES_FETCHED,
        RANGE_QUERY_DIRECT_BUFFER_HIT,
        RANGE_QUERY_DIRECT_BUFFER_MISS,
        RANGE_QUERY_FETCHES,
        RANGE_QUERY_RECORDS_FETCHED,
        RANGE_QUERY_CHUNK_FAILED,
        RANGE_QUERY_FETCH_TIME_NANOS{

            @Override
            public boolean isTimeEvent() {
                return true;
            }
        };

    }
}

