/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.sqlserver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.CleanModePlugin;
import org.flywaydb.core.internal.command.clean.CleanModeConfigurationExtension;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.database.sqlserver.SQLServerConnection;
import org.flywaydb.database.sqlserver.SQLServerEngineEdition;

public class SQLServerDatabase
extends Database<SQLServerConnection> {
    public SQLServerDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected SQLServerConnection doGetConnection(Connection connection) {
        return new SQLServerConnection(this, connection);
    }

    public final void ensureSupported() {
        if (this.isAzure()) {
            this.ensureDatabaseIsRecentEnough("11.0");
            this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("12.0", Edition.ENTERPRISE);
            this.recommendFlywayUpgradeIfNecessary("12.0");
        } else {
            this.ensureDatabaseIsRecentEnough("10.0");
            this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("14.0", Edition.ENTERPRISE);
            this.recommendFlywayUpgradeIfNecessary("16.0");
        }
    }

    protected String computeVersionDisplayName(MigrationVersion version) {
        if (this.isAzure()) {
            return "Azure v" + this.getVersion().getMajorAsString();
        }
        if (this.getVersion().isAtLeast("8")) {
            if ("8".equals(this.getVersion().getMajorAsString())) {
                return "2000";
            }
            if ("9".equals(this.getVersion().getMajorAsString())) {
                return "2005";
            }
            if ("10".equals(this.getVersion().getMajorAsString())) {
                if ("0".equals(this.getVersion().getMinorAsString())) {
                    return "2008";
                }
                return "2008 R2";
            }
            if ("11".equals(this.getVersion().getMajorAsString())) {
                return "2012";
            }
            if ("12".equals(this.getVersion().getMajorAsString())) {
                return "2014";
            }
            if ("13".equals(this.getVersion().getMajorAsString())) {
                return "2016";
            }
            if ("14".equals(this.getVersion().getMajorAsString())) {
                return "2017";
            }
            if ("15".equals(this.getVersion().getMajorAsString())) {
                return "2019";
            }
            if ("16".equals(this.getVersion().getMajorAsString())) {
                return "2022";
            }
        }
        return super.computeVersionDisplayName(version);
    }

    public Delimiter getDefaultDelimiter() {
        return Delimiter.GO;
    }

    protected String doGetCurrentUser() throws SQLException {
        return ((SQLServerConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT SUSER_SNAME()", new String[0]);
    }

    public boolean supportsDdlTransactions() {
        return true;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    private String escapeIdentifier(String identifier) {
        return StringUtils.replaceAll((String)identifier, (String)this.getCloseQuote(), (String)this.getEscapedQuote());
    }

    public String doQuote(String identifier) {
        return this.getOpenQuote() + this.escapeIdentifier(identifier) + this.getCloseQuote();
    }

    public String getOpenQuote() {
        return "[";
    }

    public String getCloseQuote() {
        return "]";
    }

    public String getEscapedQuote() {
        return "]]";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public boolean useSingleConnection() {
        return true;
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        String filegroup = this.isAzure() || this.configuration.getTablespace() == null ? "" : " ON \"" + this.configuration.getTablespace() + "\"";
        return "CREATE TABLE " + table + " (\n    [installed_rank] INT NOT NULL,\n    [version] NVARCHAR(50),\n    [description] NVARCHAR(200),\n    [type] NVARCHAR(20) NOT NULL,\n    [script] NVARCHAR(1000) NOT NULL,\n    [checksum] INT,\n    [installed_by] NVARCHAR(100) NOT NULL,\n    [installed_on] DATETIME NOT NULL DEFAULT GETDATE(),\n    [execution_time] INT NOT NULL,\n    [success] BIT NOT NULL\n)" + filegroup + ";\n" + (baseline ? this.getBaselineStatement(table) + ";\n" : "") + "ALTER TABLE " + table + " ADD CONSTRAINT [" + table.getName() + "_pk] PRIMARY KEY ([installed_rank]);\nCREATE INDEX [" + table.getName() + "_s_idx] ON " + table + " ([success]);\nGO\n";
    }

    boolean isAzure() {
        return ((SQLServerConnection)this.getMainConnection()).isAzureConnection();
    }

    SQLServerEngineEdition getEngineEdition() {
        return ((SQLServerConnection)this.getMainConnection()).getEngineEdition();
    }

    boolean supportsTemporalTables() {
        return this.isAzure() || this.getVersion().isAtLeast("13.0");
    }

    protected boolean supportsPartitions() {
        return this.isAzure() || SQLServerEngineEdition.ENTERPRISE.equals((Object)this.getEngineEdition()) || this.getVersion().isAtLeast("13");
    }

    protected boolean supportsSequences() {
        return this.getVersion().isAtLeast("11");
    }

    protected boolean supportsSynonyms() {
        return true;
    }

    protected boolean supportsRules() {
        return true;
    }

    protected boolean supportsTypes() {
        return true;
    }

    protected boolean supportsTriggers() {
        return true;
    }

    protected boolean supportsAssemblies() {
        return true;
    }

    protected boolean hasXmlSchemaCollections() {
        return true;
    }

    protected void doCleanPostSchemas(Schema[] schemas) throws SQLException {
        if (this.supportsPartitions()) {
            for (String statement : this.cleanPartitionSchemes()) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
            for (String statement : this.cleanPartitionFunctions()) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (this.supportsAssemblies()) {
            for (String statement : this.cleanAssemblies()) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (this.supportsTypes()) {
            for (String statement : this.cleanTypes(schemas)) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        String cleanMode = ((CleanModeConfigurationExtension)this.configuration.getPluginRegister().getPlugin(CleanModeConfigurationExtension.class)).getClean().getMode();
        if (CleanModeConfigurationExtension.Mode.ALL.name().equals(cleanMode)) {
            CleanModePlugin cleanModePlugin = this.configuration.getPluginRegister().getPlugins(CleanModePlugin.class).stream().filter(p -> p.handlesMode(CleanModeConfigurationExtension.Mode.valueOf((String)cleanMode))).filter(p -> p.handlesDatabase((Database)this)).findFirst().orElseThrow(() -> new FlywayException("No plugin found to handle clean mode " + cleanMode + " for SQLServer. Please ensure you have the `flyway-desktop-clean` module on the classpath"));
            cleanModePlugin.cleanDatabasePostSchema((Database)this, this.jdbcTemplate);
        }
    }

    private List<String> cleanTypes(Schema[] schemas) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        String schemaList = Arrays.stream(schemas).map(s -> "'" + s.getName() + "'").collect(Collectors.joining(","));
        if (schemaList.isEmpty()) {
            schemaList = "''";
        }
        List typesAndSchemas = this.jdbcTemplate.queryForList("SELECT t.name as type_name, s.name as schema_name FROM sys.types t INNER JOIN sys.schemas s ON t.schema_id = s.schema_id WHERE t.is_user_defined = 1 AND s.name IN (" + schemaList + ")", new Object[0]);
        for (Map typeAndSchema : typesAndSchemas) {
            statements.add("DROP TYPE " + this.quote(new String[]{(String)typeAndSchema.get("schema_name"), (String)typeAndSchema.get("type_name")}));
        }
        return statements;
    }

    private List<String> cleanPartitionSchemes() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        List partitionSchemeNames = this.jdbcTemplate.queryForStringList("SELECT name FROM sys.partition_schemes", new String[0]);
        for (String partitionSchemeName : partitionSchemeNames) {
            statements.add("DROP PARTITION SCHEME " + this.quote(new String[]{partitionSchemeName}));
        }
        return statements;
    }

    private List<String> cleanAssemblies() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        List assemblyNames = this.jdbcTemplate.queryForStringList("SELECT * FROM sys.assemblies WHERE is_user_defined=1", new String[0]);
        for (String assemblyName : assemblyNames) {
            statements.add("DROP ASSEMBLY " + this.quote(new String[]{assemblyName}));
        }
        return statements;
    }

    private List<String> cleanPartitionFunctions() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        List partitionFunctionNames = this.jdbcTemplate.queryForStringList("SELECT name FROM sys.partition_functions", new String[0]);
        for (String partitionFunctionName : partitionFunctionNames) {
            statements.add("DROP PARTITION FUNCTION " + this.quote(new String[]{partitionFunctionName}));
        }
        return statements;
    }

    public Schema[] getAllSchemas() {
        try {
            List allSchemaNames = this.jdbcTemplate.queryForStringList("(SELECT s.name\nFROM sys.schemas s\nINNER JOIN sys.sysusers u ON u.uid = s.principal_id\nWHERE u.issqluser = 1 AND u.name NOT IN ('sys', 'guest', 'INFORMATION_SCHEMA')\n) UNION (\nSELECT s.name\nFROM sys.schemas s\nINNER JOIN sys.sysusers u ON u.uid = s.schema_id\nWHERE u.islogin = 1 AND u.name NOT IN ('sys', 'guest', 'INFORMATION_SCHEMA')\n) UNION (\nSELECT DISTINCT s.name\nFROM sys.schemas s\nINNER JOIN sys.objects o ON o.schema_id = s.schema_id\nWHERE o.is_ms_shipped = 0)", new String[0]);
            return (Schema[])allSchemaNames.stream().map(n -> ((SQLServerConnection)this.getMainConnection()).getSchema((String)n)).toArray(Schema[]::new);
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to determine all schemas", (Throwable)e);
        }
    }
}

