/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.clean;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.clean.CleanModeCleanExecutor;
import org.flywaydb.clean.CleanModeSupportedDatabases;
import org.flywaydb.core.FlywayExecutor;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.TelemetrySpan;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.api.output.CommandResultFactory;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.command.clean.CleanModeConfigurationExtension;
import org.flywaydb.core.internal.command.clean.CleanModel;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.TelemetryUtils;

public class CleanModeCommandExtension
implements CommandExtension {
    private static final String CLEAN_SCHEMAS = "clean-schemas";
    private static final String CLEAN_ALL = "clean-all";
    private static final List<String> SUPPORTED_COMMANDS = Arrays.asList("clean-schemas", "clean-all");

    public boolean handlesCommand(String command) {
        return SUPPORTED_COMMANDS.contains(command.toLowerCase());
    }

    public boolean handlesParameter(String parameter) {
        return false;
    }

    public OperationResult handle(String command, Configuration config, List<String> flags) throws FlywayException {
        FlywayTelemetryManager flywayTelemetryManager = TelemetryUtils.getTelemetryManager((Configuration)config);
        return (OperationResult)TelemetrySpan.trackSpan((EventTelemetryModel)new EventTelemetryModel("cleanmode", flywayTelemetryManager), telemetryModel -> (CleanResult)new FlywayExecutor(config).execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> CleanModeCommandExtension.cleanMode(config, schemaHistory, database, defaultSchema, callbackExecutor), false, flywayTelemetryManager));
    }

    private static CleanResult cleanMode(Configuration config, SchemaHistory schemaHistory, Database database, Schema defaultSchema, CallbackExecutor callbackExecutor) {
        if (!CleanModeSupportedDatabases.supportsCleanMode(database)) {
            throw new FlywayException("Clean modes other than default are not supported for " + database.getDatabaseType().getName());
        }
        if (config.getSchemas().length > 0) {
            throw new FlywayException("'flyway.schemas' must be empty when using clean modes other than default");
        }
        CleanResult cleanResult = CommandResultFactory.createCleanResult((String)database.getCatalog());
        CleanModel clean = ConfigUtils.getCleanModel((Configuration)config);
        CleanModeCleanExecutor cleanExecutor = new CleanModeCleanExecutor(database.getMainConnection(), database, schemaHistory, callbackExecutor, clean.getMode());
        Schema[] allSchemas = (Schema[])Arrays.stream(database.getAllSchemas()).filter(s -> clean == null || clean.getSchemas() == null || !clean.getSchemas().getExclude().contains(s.getName())).toArray(Schema[]::new);
        if (clean != null) {
            if (CleanModeConfigurationExtension.Mode.SCHEMA.name().equalsIgnoreCase(clean.getMode())) {
                cleanExecutor.clean(defaultSchema, allSchemas, cleanResult);
            } else if (CleanModeConfigurationExtension.Mode.ALL.name().equalsIgnoreCase(clean.getMode())) {
                cleanExecutor.clean(defaultSchema, allSchemas, cleanResult, Arrays.stream(allSchemas).map(Schema::getName).collect(Collectors.toList()));
            }
        }
        return cleanResult;
    }
}

