/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb;

import java.util.List;
import org.flywaydb.FlywayMissingLicenseKeyException;
import org.flywaydb.LicenseInfo;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.FlywayEditionUpgradeRequiredException;

public class LicenseGuard {
    public static void guard(Configuration configuration, List<Edition> editions, String featureName) {
        try {
            LicenseInfo licenseInfo = LicenseInfo.create(configuration.getLicenseKey());
            if (!editions.contains(licenseInfo.getLicenseType().getEdition()) || licenseInfo.getRemainingDays() <= 0L) {
                throw new FlywayEditionUpgradeRequiredException(editions.get(0), licenseInfo.getLicenseType().getEdition(), featureName);
            }
        }
        catch (FlywayMissingLicenseKeyException e) {
            throw new FlywayMissingLicenseKeyException(featureName, (Exception)((Object)e));
        }
    }
}

