/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.mysql;

import java.sql.Connection;
import java.util.Properties;
import org.flywaydb.authentication.mysql.MySQLOptionFileReader;
import org.flywaydb.authentication.mysql.teams.MySQLPropertiesProvider;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.database.mysql.MySQLDatabase;
import org.flywaydb.database.mysql.MySQLParser;

public class MySQLDatabaseType
extends BaseDatabaseType {
    private static final Log LOG = LogFactory.getLog(MySQLDatabaseType.class);
    private static final String MYSQL_LEGACY_JDBC_DRIVER = "com.mysql.jdbc.Driver";
    private static final String MARIADB_JDBC_DRIVER = "org.mariadb.jdbc.Driver";
    private Properties externalAuthProperties;

    public String getName() {
        return "MySQL";
    }

    public int getNullType() {
        return 12;
    }

    public boolean handlesJDBCUrl(String url) {
        if (url.startsWith("jdbc-secretsmanager:mysql:")) {
            return true;
        }
        return url.startsWith("jdbc:mysql:") || url.startsWith("jdbc:google:") || url.startsWith("jdbc:p6spy:mysql:") || url.startsWith("jdbc:p6spy:google:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc-secretsmanager:mysql:")) {
            return "com.amazonaws.secretsmanager.sql.AWSSecretsManagerMySQLDriver";
        }
        if (url.startsWith("jdbc:p6spy:mysql:") || url.startsWith("jdbc:p6spy:google:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        if (url.startsWith("jdbc:mysql:")) {
            return "com.mysql.cj.jdbc.Driver";
        }
        return "com.mysql.jdbc.GoogleDriver";
    }

    public String getBackupDriverClass(String url, ClassLoader classLoader) {
        if (ClassUtils.isPresent((String)MYSQL_LEGACY_JDBC_DRIVER, (ClassLoader)classLoader)) {
            return MYSQL_LEGACY_JDBC_DRIVER;
        }
        if (ClassUtils.isPresent((String)MARIADB_JDBC_DRIVER, (ClassLoader)classLoader) && !url.contains("disableMariaDbDriver")) {
            return MARIADB_JDBC_DRIVER;
        }
        return null;
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.contains("MySQL");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new MySQLDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new MySQLParser(configuration, parsingContext);
    }

    public void setDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
        props.put("connectionAttributes", "program_name:Flyway by Redgate");
    }

    public boolean detectPasswordRequiredByUrl(String url) {
        if (url.startsWith("jdbc-secretsmanager:mysql:")) {
            return false;
        }
        return super.detectPasswordRequiredByUrl(url);
    }

    public boolean externalAuthPropertiesRequired(String url, String username, String password) {
        return !StringUtils.hasText((String)username) && this.detectUserRequiredByUrl(url) || !StringUtils.hasText((String)password) && this.detectPasswordRequiredByUrl(url);
    }

    public Properties getExternalAuthProperties(String url, String username) {
        MySQLOptionFileReader mySQLOptionFileReader = new MySQLOptionFileReader();
        if (this.externalAuthProperties == null) {
            this.externalAuthProperties = new MySQLPropertiesProvider(mySQLOptionFileReader).get();
        }
        return this.externalAuthProperties;
    }

    public String instantiateClassExtendedErrorMessage() {
        return "Failure probably due to inability to load dependencies. Please ensure you have downloaded 'https://dev.mysql.com/downloads/connector/j/' and extracted to 'flyway/drivers' folder";
    }
}

