/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.bigquery;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.database.bigquery.BigQueryDatabase;
import org.flywaydb.database.bigquery.BigQueryJdbcTemplate;
import org.flywaydb.database.bigquery.BigQuerySchema;

public class BigQueryConnection
extends org.flywaydb.core.internal.database.base.Connection<BigQueryDatabase> {
    private static final Pattern DEFAULT_DATASET_PATTERN = Pattern.compile("DefaultDataset=([a-zA-Z0-9]*);");

    BigQueryConnection(BigQueryDatabase database, Connection connection) {
        super((Database)database, connection);
        this.jdbcTemplate = new BigQueryJdbcTemplate(connection);
    }

    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        String defaultDataset = this.getJdbcClientOption("DefaultDataset");
        return StringUtils.hasText((String)defaultDataset) ? defaultDataset.trim() : null;
    }

    public void changeCurrentSchemaTo(Schema schema) {
    }

    public void doChangeCurrentSchemaOrSearchPathTo(String schema) {
    }

    public Schema doGetCurrentSchema() throws SQLException {
        String defaultDataset = this.parseDefaultDatasetFromUrl();
        return StringUtils.hasText((String)defaultDataset) ? this.getSchema(defaultDataset.trim()) : null;
    }

    private String parseDefaultDatasetFromUrl() throws SQLException {
        String url = this.getJdbcConnection().getMetaData().getURL();
        Matcher matcher = DEFAULT_DATASET_PATTERN.matcher(url);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getJdbcClientOption(String option) throws SQLException {
        return this.getJdbcConnection().getClientInfo(option);
    }

    public Schema getSchema(String name) {
        return new BigQuerySchema(this.jdbcTemplate, (BigQueryDatabase)this.database, name);
    }
}

