/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.flywaydb.commandline.ConsoleLog;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;

class FileLog
implements Log {
    private final Path path;
    private final ConsoleLog.Level level;

    public FileLog(Path path, ConsoleLog.Level level) {
        this.path = path;
        this.level = level;
    }

    public boolean isDebugEnabled() {
        return this.level == ConsoleLog.Level.DEBUG;
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.writeLogMessage("DEBUG", message);
        }
    }

    public void info(String message) {
        if (this.level.compareTo(ConsoleLog.Level.INFO) <= 0) {
            this.writeLogMessage(message);
        }
    }

    public void warn(String message) {
        this.writeLogMessage("WARNING", message);
    }

    public void error(String message) {
        this.writeLogMessage("ERROR", message);
    }

    public void error(String message, Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String stackTrace = stringWriter.toString();
        this.writeLogMessage("ERROR", message);
        this.writeLogMessage(stackTrace);
    }

    private void writeLogMessage(String prefix, String message) {
        String logMessage = prefix + ": " + message;
        this.writeLogMessage(logMessage);
    }

    private void writeLogMessage(String logMessage) {
        try {
            Files.write(this.path, (logMessage + "\n").getBytes(), StandardOpenOption.APPEND, StandardOpenOption.WRITE);
        }
        catch (IOException exception) {
            throw new FlywayException("Could not write to file at " + this.path + ".", (Throwable)exception);
        }
    }
}

