/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;

class ThreadUtils {
    ThreadUtils() {
    }

    static void terminate(int exitCode, AutoCloseable flywayTelemetryHandle) {
        try {
            flywayTelemetryHandle.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (exitCode != 0) {
            System.exit(exitCode);
        }
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(500L);
                for (int i = 1; i <= 5; ++i) {
                    ThreadUtils.stopThreads();
                    Thread.sleep(100L);
                }
                Runtime.getRuntime().halt(0);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        t.setDaemon(true);
        t.start();
    }

    private static void stopThreads() {
        Thread current = Thread.currentThread();
        ThreadGroup root = ThreadUtils.getRootThreadGroup();
        Thread[] threads = ThreadUtils.snapshotThreads(root, current);
        if (threads.length == 0) {
            return;
        }
        for (Thread eligibleThread : threads) {
            eligibleThread.interrupt();
        }
        long deadline = System.nanoTime() + Duration.ofSeconds(1L).toNanos();
        for (Thread eligibleThread : threads) {
            long remaining = deadline - System.nanoTime();
            if (remaining <= 0L) break;
            long ms = Math.max(0L, remaining / 1000000L);
            int ns = (int)Math.max(0L, remaining % 1000000L);
            try {
                eligibleThread.join(ms, ns);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static Thread[] snapshotThreads(ThreadGroup root, Thread current) {
        Thread[] threads;
        int size;
        int n = root.activeCount();
        while ((size = n * 2) > (n = root.enumerate(threads = new Thread[size], true))) {
        }
        HashSet<String> knownSystemThreads = new HashSet<String>(Arrays.asList("Finalizer", "Reference Handler", "Signal Dispatcher", "Common-Cleaner"));
        return (Thread[])Arrays.stream(threads).filter(Objects::nonNull).filter(t -> t != current).filter(t -> !t.isDaemon()).filter(t -> !knownSystemThreads.contains(t.getName())).toArray(Thread[]::new);
    }

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup current = Thread.currentThread().getThreadGroup();
        ThreadGroup parent = current.getParent();
        while (parent != null) {
            current = parent;
            parent = current.getParent();
        }
        return current;
    }
}

