/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.command.dbsupport;

import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.commandline.command.dbsupport.DbInfoResult;
import org.flywaydb.commandline.command.dbsupport.DbSupportResult;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;

public class ListEnginesCommandExtension
implements CommandExtension {
    private static final Log LOG = LogFactory.getLog(ListEnginesCommandExtension.class);
    private static final String DB_SUPPORT = "list-engines";
    private static final String HEADERS_DATABASE_NAME = "Database Name";

    public boolean handlesCommand(String command) {
        return command.equals(DB_SUPPORT);
    }

    public boolean handlesParameter(String parameter) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OperationResult handle(String command, Configuration config, List<String> flags, FlywayTelemetryManager flywayTelemetryManager) throws FlywayException {
        EventTelemetryModel telemetryModel = new EventTelemetryModel(DB_SUPPORT, flywayTelemetryManager);
        try {
            List allPlugins = config.getPluginRegister().getPlugins(DatabaseType.class);
            List<DbInfoResult> databaseInfos = allPlugins.stream().map(p -> new DbInfoResult(p.getName())).collect(Collectors.toList());
            if (!databaseInfos.isEmpty()) {
                int nameLength = databaseInfos.stream().map(p -> p.name().length()).max(Integer::compare).get() + 2;
                if (nameLength < HEADERS_DATABASE_NAME.length() + 2) {
                    nameLength = HEADERS_DATABASE_NAME.length() + 2;
                }
                LOG.info(StringUtils.rightPad((String)HEADERS_DATABASE_NAME, (int)nameLength, (char)' '));
                LOG.info(StringUtils.rightPad((String)StringUtils.leftPad((String)"", (int)nameLength, (char)'-'), (int)nameLength, (char)' '));
                for (DbInfoResult p2 : databaseInfos) {
                    LOG.info(StringUtils.rightPad((String)p2.name(), (int)nameLength, (char)' '));
                }
            }
            DbSupportResult dbSupportResult = new DbSupportResult(VersionPrinter.getVersion(), command, LicenseGuard.getTier((Configuration)config), databaseInfos);
            return dbSupportResult;
        }
        catch (Exception e) {
            telemetryModel.setException(e);
            throw e;
        }
        finally {
            try {
                telemetryModel.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public List<Pair<String, String>> getUsage() {
        return List.of(Pair.of((Object)DB_SUPPORT, (Object)"Lists the database engines that Flyway has loaded support for."));
    }
}

