/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import javax.net.ssl.HttpsURLConnection;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.license.VersionPrinter;

public class MavenVersionChecker {
    private static final Log LOG = LogFactory.getLog(MavenVersionChecker.class);
    private static final String FLYWAY_URL = "https://repo1.maven.org/maven2/org/flywaydb/flyway-core/maven-metadata.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForVersionUpdates() {
        try {
            URL url = new URL(FLYWAY_URL);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            try {
                MigrationVersion latest;
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "Flyway");
                connection.setConnectTimeout(500);
                StringBuilder response = new StringBuilder();
                try (BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String line;
                    while ((line = rd.readLine()) != null) {
                        response.append(line);
                    }
                }
                XmlMapper xmlMapper = new XmlMapper();
                MavenMetadata metadata = (MavenMetadata)xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(response.toString(), MavenMetadata.class);
                MigrationVersion current = MigrationVersion.fromVersion((String)VersionPrinter.getVersion());
                if (current.compareTo(latest = MigrationVersion.fromVersion((String)metadata.getVersioning().getRelease())) < 0) {
                    LOG.info("A more recent version of Flyway is available. Find out more about Flyway " + latest + " at https://rd.gt/3rXiSlV\n");
                }
            }
            finally {
                if (Collections.singletonList(connection).get(0) != null) {
                    connection.disconnect();
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Unable to check for updates: " + e.getMessage());
        }
    }

    private MavenVersionChecker() {
    }

    private static class MavenMetadata {
        private MavenVersioning versioning;

        public void setVersioning(MavenVersioning versioning) {
            this.versioning = versioning;
        }

        public MavenVersioning getVersioning() {
            return this.versioning;
        }
    }

    private static class MavenVersioning {
        private String release;

        public void setRelease(String release) {
            this.release = release;
        }

        public String getRelease() {
            return this.release;
        }
    }
}

