/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.query.Query;
import org.flowable.engine.common.impl.AbstractQuery;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;
import org.flowable.variable.api.types.VariableTypes;
import org.flowable.variable.service.impl.QueryOperator;
import org.flowable.variable.service.impl.QueryVariableValue;
import org.flowable.variable.service.impl.util.CommandContextUtil;

public abstract class AbstractVariableQueryImpl<T extends Query<?, ?>, U>
extends AbstractQuery<T, U> {
    private static final long serialVersionUID = 1L;
    protected List<QueryVariableValue> queryVariableValues = new ArrayList<QueryVariableValue>();

    public AbstractVariableQueryImpl() {
    }

    public AbstractVariableQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public AbstractVariableQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public abstract long executeCount(CommandContext var1);

    public abstract List<U> executeList(CommandContext var1);

    public T variableValueEquals(String name, Object value) {
        return this.variableValueEquals(name, value, true);
    }

    protected T variableValueEquals(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.EQUALS, localScope);
        return (T)((Object)this);
    }

    public T variableValueEquals(Object value) {
        return this.variableValueEquals(value, true);
    }

    protected T variableValueEquals(Object value, boolean localScope) {
        this.queryVariableValues.add(new QueryVariableValue(null, value, QueryOperator.EQUALS, localScope));
        return (T)((Object)this);
    }

    public T variableValueEqualsIgnoreCase(String name, String value) {
        return this.variableValueEqualsIgnoreCase(name, value, true);
    }

    protected T variableValueEqualsIgnoreCase(String name, String value, boolean localScope) {
        if (value == null) {
            throw new FlowableIllegalArgumentException("value is null");
        }
        this.addVariable(name, value.toLowerCase(), QueryOperator.EQUALS_IGNORE_CASE, localScope);
        return (T)((Object)this);
    }

    public T variableValueNotEqualsIgnoreCase(String name, String value) {
        return this.variableValueNotEqualsIgnoreCase(name, value, true);
    }

    protected T variableValueNotEqualsIgnoreCase(String name, String value, boolean localScope) {
        if (value == null) {
            throw new FlowableIllegalArgumentException("value is null");
        }
        this.addVariable(name, value.toLowerCase(), QueryOperator.NOT_EQUALS_IGNORE_CASE, localScope);
        return (T)((Object)this);
    }

    public T variableValueNotEquals(String name, Object value) {
        return this.variableValueNotEquals(name, value, true);
    }

    protected T variableValueNotEquals(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.NOT_EQUALS, localScope);
        return (T)((Object)this);
    }

    public T variableValueGreaterThan(String name, Object value) {
        return this.variableValueGreaterThan(name, value, true);
    }

    protected T variableValueGreaterThan(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN, localScope);
        return (T)((Object)this);
    }

    public T variableValueGreaterThanOrEqual(String name, Object value) {
        return this.variableValueGreaterThanOrEqual(name, value, true);
    }

    protected T variableValueGreaterThanOrEqual(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN_OR_EQUAL, localScope);
        return (T)((Object)this);
    }

    public T variableValueLessThan(String name, Object value) {
        return this.variableValueLessThan(name, value, true);
    }

    protected T variableValueLessThan(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.LESS_THAN, localScope);
        return (T)((Object)this);
    }

    public T variableValueLessThanOrEqual(String name, Object value) {
        return this.variableValueLessThanOrEqual(name, value, true);
    }

    protected T variableValueLessThanOrEqual(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.LESS_THAN_OR_EQUAL, localScope);
        return (T)((Object)this);
    }

    public T variableValueLike(String name, String value) {
        return this.variableValueLike(name, value, true);
    }

    public T variableValueLikeIgnoreCase(String name, String value) {
        return this.variableValueLikeIgnoreCase(name, value, true);
    }

    protected T variableValueLike(String name, String value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.LIKE, localScope);
        return (T)((Object)this);
    }

    protected T variableValueLikeIgnoreCase(String name, String value, boolean localScope) {
        this.addVariable(name, value.toLowerCase(), QueryOperator.LIKE_IGNORE_CASE, localScope);
        return (T)((Object)this);
    }

    public T variableExists(String name) {
        return this.variableExists(name, true);
    }

    protected T variableExists(String name, boolean localScope) {
        this.addVariable(name, null, QueryOperator.EXISTS, localScope);
        return (T)((Object)this);
    }

    public T variableNotExists(String name) {
        return this.variableNotExists(name, true);
    }

    protected T variableNotExists(String name, boolean localScope) {
        this.addVariable(name, null, QueryOperator.NOT_EXISTS, localScope);
        return (T)((Object)this);
    }

    protected void addVariable(String name, Object value, QueryOperator operator, boolean localScope) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("name is null");
        }
        if (value == null || this.isBoolean(value)) {
            switch (operator) {
                case GREATER_THAN: {
                    throw new FlowableIllegalArgumentException("Booleans and null cannot be used in 'greater than' condition");
                }
                case LESS_THAN: {
                    throw new FlowableIllegalArgumentException("Booleans and null cannot be used in 'less than' condition");
                }
                case GREATER_THAN_OR_EQUAL: {
                    throw new FlowableIllegalArgumentException("Booleans and null cannot be used in 'greater than or equal' condition");
                }
                case LESS_THAN_OR_EQUAL: {
                    throw new FlowableIllegalArgumentException("Booleans and null cannot be used in 'less than or equal' condition");
                }
            }
            if (operator == QueryOperator.EQUALS_IGNORE_CASE && !(value instanceof String)) {
                throw new FlowableIllegalArgumentException("Only string values can be used with 'equals ignore case' condition");
            }
            if (operator == QueryOperator.NOT_EQUALS_IGNORE_CASE && !(value instanceof String)) {
                throw new FlowableIllegalArgumentException("Only string values can be used with 'not equals ignore case' condition");
            }
            if (!(operator != QueryOperator.LIKE && operator != QueryOperator.LIKE_IGNORE_CASE || value instanceof String)) {
                throw new FlowableIllegalArgumentException("Only string values can be used with 'like' condition");
            }
        }
        this.queryVariableValues.add(new QueryVariableValue(name, value, operator, localScope));
    }

    protected boolean isBoolean(Object value) {
        if (value == null) {
            return false;
        }
        return Boolean.class.isAssignableFrom(value.getClass()) || Boolean.TYPE.isAssignableFrom(value.getClass());
    }

    protected void ensureVariablesInitialized() {
        if (!this.queryVariableValues.isEmpty()) {
            VariableTypes variableTypes = CommandContextUtil.getVariableServiceConfiguration().getVariableTypes();
            for (QueryVariableValue queryVariableValue : this.queryVariableValues) {
                queryVariableValue.initialize(variableTypes);
            }
        }
    }

    public List<QueryVariableValue> getQueryVariableValues() {
        return this.queryVariableValues;
    }

    public boolean hasValueComparisonQueryVariables() {
        for (QueryVariableValue qvv : this.queryVariableValues) {
            if (QueryOperator.EXISTS.toString().equals(qvv.getOperator()) || QueryOperator.NOT_EXISTS.toString().equals(qvv.getOperator())) continue;
            return true;
        }
        return false;
    }

    public boolean hasLocalQueryVariableValue() {
        for (QueryVariableValue qvv : this.queryVariableValues) {
            if (!qvv.isLocal()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNonLocalQueryVariableValue() {
        for (QueryVariableValue qvv : this.queryVariableValues) {
            if (qvv.isLocal()) continue;
            return true;
        }
        return false;
    }
}

