/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import java.util.List;
import org.flowable.ui.task.model.runtime.TaskRepresentation;
import org.flowable.ui.task.model.runtime.TaskUpdateRepresentation;
import org.flowable.ui.task.service.runtime.FlowableTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class TaskResource {
    @Autowired
    protected FlowableTaskService taskService;

    @GetMapping(value={"/rest/tasks/{taskId}"}, produces={"application/json"})
    public TaskRepresentation getTask(@PathVariable String taskId) {
        return this.taskService.getTask(taskId);
    }

    @PutMapping(value={"/rest/tasks/{taskId}"}, produces={"application/json"})
    public TaskRepresentation updateTask(@PathVariable(value="taskId") String taskId, @RequestBody TaskUpdateRepresentation updated) {
        return this.taskService.updateTask(taskId, updated);
    }

    @GetMapping(value={"/rest/tasks/{taskId}/subtasks"}, produces={"application/json"})
    public List<TaskRepresentation> getSubTasks(@PathVariable String taskId) {
        return this.taskService.getSubTasks(taskId);
    }
}

