/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.idm;

import javax.servlet.http.HttpServletResponse;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class UserResource
implements InitializingBean {
    @Autowired(required=false)
    protected RemoteIdmService remoteIdmService;
    @Autowired(required=false)
    protected IdmIdentityService identityService;

    public void afterPropertiesSet() {
        if (this.remoteIdmService == null && this.identityService == null) {
            throw new FlowableIllegalStateException("No remoteIdmService or identityService have been provided");
        }
    }

    @GetMapping(value={"/rest/users/{userId}"}, produces={"application/json"})
    public UserRepresentation getUser(@PathVariable String userId, HttpServletResponse response) {
        Object user = this.remoteIdmService != null ? this.remoteIdmService.getUser(userId) : (User)((UserQuery)this.identityService.createUserQuery().userId(userId)).singleResult();
        if (user == null) {
            throw new NotFoundException("User with id: " + userId + " does not exist or is inactive");
        }
        return new UserRepresentation((User)user);
    }
}

