/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.service.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.flowable.cmmn.api.CmmnTaskService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.TaskService;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.ui.common.security.SecurityScope;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.common.service.exception.NotPermittedException;
import org.flowable.ui.task.model.runtime.CompleteFormRepresentation;
import org.flowable.ui.task.model.runtime.SaveFormRepresentation;
import org.flowable.ui.task.service.runtime.PermissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableTaskFormService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableTaskFormService.class);
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected CmmnTaskService cmmnTaskService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected FormRepositoryService formRepositoryService;
    @Autowired
    protected FormService formService;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected ObjectMapper objectMapper;

    public FormInfo getTaskForm(String taskId) {
        HistoricTaskInstance task = this.permissionService.validateReadPermissionOnTask(SecurityUtils.getAuthenticatedSecurityScope(), taskId);
        if (task.getProcessInstanceId() != null) {
            return this.taskService.getTaskFormModel(task.getId());
        }
        return this.cmmnTaskService.getTaskFormModel(task.getId());
    }

    public void saveTaskForm(String taskId, SaveFormRepresentation saveFormRepresentation) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task not found with id: " + taskId);
        }
        this.checkCurrentUserCanModifyTask(task);
        FormInfo formInfo = this.formRepositoryService.getFormModelById(saveFormRepresentation.getFormId());
        Map<String, Object> formVariables = saveFormRepresentation.getValues();
        if (task.getProcessInstanceId() != null) {
            this.formService.saveFormInstanceByFormDefinitionId(formVariables, saveFormRepresentation.getFormId(), taskId, task.getProcessInstanceId(), task.getProcessDefinitionId(), task.getTenantId(), null);
        } else {
            this.formService.saveFormInstanceWithScopeId(formVariables, saveFormRepresentation.getFormId(), taskId, task.getScopeId(), task.getScopeType(), task.getScopeDefinitionId(), task.getTenantId(), null);
        }
    }

    public void completeTaskForm(String taskId, CompleteFormRepresentation completeTaskFormRepresentation) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task not found with id: " + taskId);
        }
        this.checkCurrentUserCanModifyTask(task);
        if (task.getProcessInstanceId() != null) {
            this.taskService.completeTaskWithForm(taskId, completeTaskFormRepresentation.getFormId(), completeTaskFormRepresentation.getOutcome(), completeTaskFormRepresentation.getValues());
        } else {
            this.cmmnTaskService.completeTaskWithForm(taskId, completeTaskFormRepresentation.getFormId(), completeTaskFormRepresentation.getOutcome(), completeTaskFormRepresentation.getValues());
        }
    }

    protected void checkCurrentUserCanModifyTask(Task task) {
        SecurityScope currentUser = SecurityUtils.getAuthenticatedSecurityScope();
        if (!this.permissionService.isTaskOwnerOrAssignee(currentUser, task.getId()) && !this.permissionService.validateIfUserIsInitiatorAndCanCompleteTask(currentUser, task)) {
            throw new NotPermittedException();
        }
    }
}

