/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.service.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.api.repository.AppDefinitionQuery;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.repository.CaseDefinitionQuery;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.task.model.runtime.CaseDefinitionRepresentation;
import org.flowable.ui.task.service.runtime.PermissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableCaseDefinitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableCaseDefinitionService.class);
    @Autowired
    protected CmmnRepositoryService cmmnRepositoryService;
    @Autowired
    protected AppRepositoryService appRepositoryService;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected FormRepositoryService formRepositoryService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultListDataRepresentation getCaseDefinitions(Boolean latest, String appDefinitionKey) {
        CaseDefinitionQuery definitionQuery = this.cmmnRepositoryService.createCaseDefinitionQuery();
        if (appDefinitionKey != null) {
            AppDefinition appDefinition = (AppDefinition)((AppDefinitionQuery)((AppDefinitionQuery)this.appRepositoryService.createAppDefinitionQuery().appDefinitionKey(appDefinitionKey)).latestVersion()).singleResult();
            CmmnDeployment deployment = (CmmnDeployment)this.cmmnRepositoryService.createDeploymentQuery().parentDeploymentId(appDefinition.getDeploymentId()).singleResult();
            if (deployment == null) return new ResultListDataRepresentation(new ArrayList());
            definitionQuery.deploymentId(deployment.getId());
        } else if (latest != null && latest.booleanValue()) {
            definitionQuery.latestVersion();
        }
        List definitions = definitionQuery.list();
        return new ResultListDataRepresentation(this.convertDefinitionList(definitions));
    }

    public FormInfo getCaseDefinitionStartForm(String caseDefinitionId) {
        CaseDefinition caseDefinition = this.cmmnRepositoryService.getCaseDefinition(caseDefinitionId);
        try {
            return this.getStartForm(caseDefinition);
        }
        catch (FlowableObjectNotFoundException aonfe) {
            throw new NotFoundException("No case definition found with the given id: " + caseDefinitionId);
        }
    }

    protected List<CaseDefinitionRepresentation> convertDefinitionList(List<CaseDefinition> definitions) {
        ArrayList<CaseDefinitionRepresentation> result = new ArrayList<CaseDefinitionRepresentation>();
        if (CollectionUtils.isNotEmpty(definitions)) {
            for (CaseDefinition caseDefinition : definitions) {
                CaseDefinitionRepresentation rep = new CaseDefinitionRepresentation(caseDefinition);
                result.add(rep);
            }
        }
        return result;
    }

    protected FormInfo getStartForm(CaseDefinition caseDefinition) {
        CmmnModel cmmnModel = this.cmmnRepositoryService.getCmmnModel(caseDefinition.getId());
        List cases = cmmnModel.getCases();
        if (cases == null || cases.size() != 1) {
            throw new FlowableObjectNotFoundException("Case definition " + caseDefinition.getId() + " start form was not found.");
        }
        Case caze = (Case)cases.get(0);
        if (caze == null || caze.getPlanModel() == null || StringUtils.isEmpty((CharSequence)caze.getPlanModel().getFormKey())) {
            throw new FlowableObjectNotFoundException("Case from case definition " + caseDefinition.getId() + " does not contain any start form.");
        }
        String formKey = caze.getPlanModel().getFormKey();
        return this.formRepositoryService.getFormModelByKey(formKey);
    }
}

