/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.flowable.bpmn.BpmnAutoLayout;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Process;
import org.flowable.cmmn.converter.CmmnXmlConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.dmn.editor.converter.DmnJsonConverter;
import org.flowable.dmn.editor.converter.DmnJsonConverterContext;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.xml.converter.DmnXMLConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.common.util.XmlUtil;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.AppDefinition;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.model.AppDefinitionListModelRepresentation;
import org.flowable.ui.modeler.model.ModelRepresentation;
import org.flowable.ui.modeler.repository.ModelRepository;
import org.flowable.ui.modeler.service.ConverterContext;
import org.flowable.ui.modeler.service.DecisionTableModelConversionUtil;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Transactional
public class FlowableModelQueryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableModelQueryService.class);
    protected static final String FILTER_SHARED_WITH_ME = "sharedWithMe";
    protected static final String FILTER_SHARED_WITH_OTHERS = "sharedWithOthers";
    protected static final String FILTER_FAVORITE = "favorite";
    protected static final int MIN_FILTER_LENGTH = 1;
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ObjectMapper objectMapper;
    protected BpmnXMLConverter bpmnXmlConverter = new BpmnXMLConverter();
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();
    protected CmmnXmlConverter cmmnXmlConverter = new CmmnXmlConverter();
    protected CmmnJsonConverter cmmnJsonConverter = new CmmnJsonConverter();
    protected DmnXMLConverter dmnXMLConverter = new DmnXMLConverter();
    protected DmnJsonConverter dmnJsonConverter = new DmnJsonConverter();

    public ResultListDataRepresentation getModels(String filter, String sort, Integer modelType, HttpServletRequest request) {
        String filterText = null;
        List params = URLEncodedUtils.parse((String)request.getQueryString(), (Charset)StandardCharsets.UTF_8);
        if (params != null) {
            for (NameValuePair nameValuePair : params) {
                if (!"filterText".equalsIgnoreCase(nameValuePair.getName())) continue;
                filterText = nameValuePair.getValue();
            }
        }
        ArrayList<ModelRepresentation> resultList = new ArrayList<ModelRepresentation>();
        List<Model> models = null;
        String validFilter = this.makeValidFilterText(filterText);
        models = validFilter != null ? this.modelRepository.findByModelTypeAndFilter(modelType, validFilter, sort) : this.modelRepository.findByModelType(modelType, sort);
        if (CollectionUtils.isNotEmpty(models)) {
            ArrayList<String> addedModelIds = new ArrayList<String>();
            for (Model model : models) {
                if (addedModelIds.contains(model.getId())) continue;
                addedModelIds.add(model.getId());
                ModelRepresentation representation = this.createModelRepresentation(model);
                resultList.add(representation);
            }
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(resultList);
        return result;
    }

    public ResultListDataRepresentation getModelsToIncludeInAppDefinition() {
        ArrayList<ModelRepresentation> resultList = new ArrayList<ModelRepresentation>();
        ArrayList<String> addedModelIds = new ArrayList<String>();
        List<Model> models = this.modelRepository.findByModelType(0, "modifiedDesc");
        if (CollectionUtils.isNotEmpty(models)) {
            for (Model model : models) {
                if (addedModelIds.contains(model.getId())) continue;
                addedModelIds.add(model.getId());
                ModelRepresentation representation = this.createModelRepresentation(model);
                resultList.add(representation);
            }
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(resultList);
        return result;
    }

    public ResultListDataRepresentation getCmmnModelsToIncludeInAppDefinition() {
        ArrayList<ModelRepresentation> resultList = new ArrayList<ModelRepresentation>();
        ArrayList<String> addedModelIds = new ArrayList<String>();
        List<Model> models = this.modelRepository.findByModelType(5, "modifiedDesc");
        if (CollectionUtils.isNotEmpty(models)) {
            for (Model model : models) {
                if (addedModelIds.contains(model.getId())) continue;
                addedModelIds.add(model.getId());
                ModelRepresentation representation = this.createModelRepresentation(model);
                resultList.add(representation);
            }
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(resultList);
        return result;
    }

    public ModelRepresentation importProcessModel(HttpServletRequest request, MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (fileName != null && (fileName.endsWith(".bpmn") || fileName.endsWith(".bpmn20.xml"))) {
            try {
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                InputStreamReader xmlIn = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
                XMLStreamReader xtr = xif.createXMLStreamReader(xmlIn);
                BpmnModel bpmnModel = this.bpmnXmlConverter.convertToBpmnModel(xtr);
                if (CollectionUtils.isEmpty((Collection)bpmnModel.getProcesses())) {
                    throw new BadRequestException("No process found in definition " + fileName);
                }
                if (bpmnModel.getLocationMap().size() == 0) {
                    BpmnAutoLayout bpmnLayout = new BpmnAutoLayout(bpmnModel);
                    bpmnLayout.execute();
                }
                ObjectNode modelNode = this.bpmnJsonConverter.convertToJson(bpmnModel);
                Process process = bpmnModel.getMainProcess();
                String name = process.getId();
                if (StringUtils.isNotEmpty((CharSequence)process.getName())) {
                    name = process.getName();
                }
                String description = process.getDocumentation();
                ModelRepresentation model = new ModelRepresentation();
                model.setKey(process.getId());
                model.setName(name);
                model.setDescription(description);
                model.setModelType(0);
                Model newModel = this.modelService.createModel(model, modelNode.toString(), SecurityUtils.getCurrentUserId());
                return new ModelRepresentation(newModel);
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Import failed for {}", (Object)fileName, (Object)e);
                throw new BadRequestException("Import failed for " + fileName + ", error message " + e.getMessage());
            }
        }
        throw new BadRequestException("Invalid file name, only .bpmn and .bpmn20.xml files are supported not " + fileName);
    }

    public ModelRepresentation importCaseModel(HttpServletRequest request, MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (fileName != null && (fileName.endsWith(".cmmn") || fileName.endsWith(".cmmn.xml"))) {
            try {
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                InputStreamReader xmlIn = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
                XMLStreamReader xtr = xif.createXMLStreamReader(xmlIn);
                CmmnModel cmmnModel = this.cmmnXmlConverter.convertToCmmnModel(xtr);
                if (CollectionUtils.isEmpty((Collection)cmmnModel.getCases())) {
                    throw new BadRequestException("No cases found in definition " + fileName);
                }
                if (cmmnModel.getLocationMap().size() == 0) {
                    throw new BadRequestException("No CMMN DI found in definition " + fileName);
                }
                ObjectNode modelNode = this.cmmnJsonConverter.convertToJson(cmmnModel);
                Case caseModel = cmmnModel.getPrimaryCase();
                String name = caseModel.getId();
                if (StringUtils.isNotEmpty((CharSequence)caseModel.getName())) {
                    name = caseModel.getName();
                }
                String description = caseModel.getDocumentation();
                ModelRepresentation model = new ModelRepresentation();
                model.setKey(caseModel.getId());
                model.setName(name);
                model.setDescription(description);
                model.setModelType(5);
                Model newModel = this.modelService.createModel(model, modelNode.toString(), SecurityUtils.getCurrentUserId());
                return new ModelRepresentation(newModel);
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Import failed for {}", (Object)fileName, (Object)e);
                throw new BadRequestException("Import failed for " + fileName + ", error message " + e.getMessage());
            }
        }
        throw new BadRequestException("Invalid file name, only .cmmn and .cmmn.xml files are supported not " + fileName);
    }

    public ModelRepresentation importDecisionServiceModel(HttpServletRequest request, MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (fileName != null && (fileName.endsWith(".dmn") || fileName.endsWith(".dmn.xml"))) {
            try {
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                InputStreamReader xmlIn = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
                XMLStreamReader xtr = xif.createXMLStreamReader(xmlIn);
                DmnDefinition dmnDefinition = this.dmnXMLConverter.convertToDmnModel(xtr);
                if (CollectionUtils.isEmpty((Collection)dmnDefinition.getDecisionServices())) {
                    throw new BadRequestException("No decision services found in definition " + fileName);
                }
                if (dmnDefinition.getLocationMap().size() == 0) {
                    throw new BadRequestException("No DMN DI found in definition " + fileName);
                }
                ConverterContext converterContext = new ConverterContext(this.modelService, this.objectMapper);
                this.parseDecisionTables(dmnDefinition, converterContext);
                this.importDecisionTables(converterContext);
                ObjectNode modelNode = this.dmnJsonConverter.convertToJson(dmnDefinition, (DmnJsonConverterContext)converterContext);
                DecisionService firstDecisionService = (DecisionService)dmnDefinition.getDecisionServices().iterator().next();
                String name = firstDecisionService.getId();
                if (StringUtils.isNotEmpty((CharSequence)firstDecisionService.getName())) {
                    name = firstDecisionService.getName();
                }
                ModelRepresentation model = new ModelRepresentation();
                model.setName(name);
                model.setDescription("");
                model.setKey(firstDecisionService.getId());
                model.setModelType(6);
                Model newModel = this.modelService.createModel(model, modelNode.toString(), SecurityUtils.getCurrentUserId());
                return new ModelRepresentation(newModel);
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Import failed for {}", (Object)fileName, (Object)e);
                throw new BadRequestException("Import failed for " + fileName + ", error message " + e.getMessage());
            }
        }
        throw new BadRequestException("Invalid file name, only .dmn and .dmn.xml files are supported not " + fileName);
    }

    protected void parseDecisionTables(DmnDefinition dmnDefinition, ConverterContext converterContext) {
        dmnDefinition.getDecisions().forEach(decision -> {
            String decisionNode = this.dmnJsonConverter.convertDecisionDecisionTableToJson(decision, "definition_" + decision.getId(), decision.getName(), null).toString();
            converterContext.getDecisionTableKeyToJsonStringMap().put(decision.getId(), decisionNode);
        });
    }

    protected void importDecisionTables(ConverterContext converterContext) {
        Map<String, String> decisionTableMap = converterContext.getDecisionTableKeyToJsonStringMap();
        String currentUserId = SecurityUtils.getCurrentUserId();
        for (String decisionTableKey : decisionTableMap.keySet()) {
            JsonNode decisionTableNode;
            String decisionTableJson = decisionTableMap.get(decisionTableKey);
            try {
                decisionTableNode = this.objectMapper.readTree(decisionTableJson);
            }
            catch (Exception e) {
                LOGGER.error("Error reading decision model json", (Throwable)e);
                throw new InternalServerErrorException("Error reading decision model json");
            }
            Model decisionTableModel = new Model();
            decisionTableModel.setName(decisionTableNode.get("name").asText());
            decisionTableModel.setKey(decisionTableNode.get("key").asText());
            String oldDecisionTableId = decisionTableNode.get("id").asText();
            JsonNode descriptionNode = decisionTableNode.get("description");
            if (descriptionNode != null && !descriptionNode.isNull()) {
                decisionTableModel.setDescription(descriptionNode.asText());
            }
            decisionTableModel.setModelEditorJson(decisionTableNode.toString());
            decisionTableModel.setModelType(4);
            DecisionTableModelConversionUtil.convertModelToV3(decisionTableModel);
            Model updatedDecisionTableModel = this.modelService.createModel(decisionTableModel, currentUserId);
            converterContext.addDecisionTableModel(updatedDecisionTableModel, oldDecisionTableId);
        }
    }

    protected ModelRepresentation createModelRepresentation(AbstractModel model) {
        ModelRepresentation representation = null;
        if (model.getModelType() != null && model.getModelType() == 3) {
            representation = new AppDefinitionListModelRepresentation(model);
            AppDefinition appDefinition = null;
            try {
                appDefinition = (AppDefinition)this.objectMapper.readValue(model.getModelEditorJson(), AppDefinition.class);
            }
            catch (Exception e) {
                LOGGER.error("Error deserializing app {}", (Object)model.getId(), (Object)e);
                throw new InternalServerErrorException("Could not deserialize app definition");
            }
            ((AppDefinitionListModelRepresentation)representation).setAppDefinition(appDefinition);
        } else {
            representation = new ModelRepresentation(model);
        }
        return representation;
    }

    protected String makeValidFilterText(String filterText) {
        String trimmed;
        String validFilter = null;
        if (filterText != null && (trimmed = StringUtils.trim((String)filterText)).length() >= 1) {
            validFilter = "%" + trimmed.toLowerCase() + "%";
        }
        return validFilter;
    }
}

