/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.dmn.editor.converter.DmnJsonConverter;
import org.flowable.dmn.editor.converter.DmnJsonConverterContext;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.xml.converter.DmnXMLConverter;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.common.util.XmlUtil;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.domain.ModelHistory;
import org.flowable.ui.modeler.model.ModelRepresentation;
import org.flowable.ui.modeler.model.decisionservice.DecisionServiceRepresentation;
import org.flowable.ui.modeler.service.BaseFlowableModelService;
import org.flowable.ui.modeler.service.ConverterContext;
import org.flowable.ui.modeler.service.DecisionTableModelConversionUtil;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class FlowableDecisionServiceService
extends BaseFlowableModelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableDecisionServiceService.class);
    protected static final int MIN_FILTER_LENGTH = 1;
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ObjectMapper objectMapper;
    protected DmnJsonConverter dmnJsonConverter = new DmnJsonConverter();
    protected DmnXMLConverter dmnXmlConverter = new DmnXMLConverter();

    public List<DecisionServiceRepresentation> getDecisionServices(String[] decisionServiceIds) {
        ArrayList<DecisionServiceRepresentation> decisionServiceRepresentations = new ArrayList<DecisionServiceRepresentation>();
        for (String decisionServiceId : decisionServiceIds) {
            Model model = this.getModel(decisionServiceId, true, false);
            DecisionServiceRepresentation decisionTableRepresentation = this.createDecisionServiceRepresentation(model);
            decisionServiceRepresentations.add(decisionTableRepresentation);
        }
        return decisionServiceRepresentations;
    }

    public ResultListDataRepresentation getDecisionServices(String filter) {
        String validFilter = this.makeValidFilterText(filter);
        List<Model> models = null;
        models = validFilter != null ? this.modelRepository.findByModelTypeAndFilter(6, validFilter, "nameAsc") : this.modelRepository.findByModelType(6, "nameAsc");
        ArrayList<DecisionServiceRepresentation> reps = new ArrayList<DecisionServiceRepresentation>();
        for (Model model : models) {
            reps.add(new DecisionServiceRepresentation(model));
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(reps);
        result.setTotal(Long.valueOf(models.size()));
        return result;
    }

    public void exportDecisionService(HttpServletResponse response, String decisionServiceId) {
        this.exportDecisionServiceDefinition(response, this.getModel(decisionServiceId, true, false));
    }

    public void exportHistoricDecisionService(HttpServletResponse response, String modelId, String modelHistoryId) {
        ModelHistory modelHistory = this.modelService.getModelHistory(modelId, modelHistoryId);
        this.getModel(modelHistory.getModelId(), true, false);
        this.exportDecisionServiceDefinition(response, modelHistory);
    }

    protected void exportDecisionServiceDefinition(HttpServletResponse response, AbstractModel definitionModel) {
        ConverterContext converterContext = new ConverterContext(this.modelService, this.objectMapper);
        List<Model> decisionTableModels = this.modelRepository.findByModelType(4, "modifiedDesc");
        Map<String, String> decisionTableEditorJSON = decisionTableModels.stream().collect(Collectors.toMap(AbstractModel::getKey, AbstractModel::getModelEditorJson));
        converterContext.getDecisionTableKeyToJsonStringMap().putAll(decisionTableEditorJSON);
        this.exportDecisionServiceDefinition(response, definitionModel, converterContext);
    }

    protected void exportDecisionServiceDefinition(HttpServletResponse response, AbstractModel definitionModel, DmnJsonConverterContext converterContext) {
        try {
            int count;
            JsonNode editorJsonNode = this.objectMapper.readTree(definitionModel.getModelEditorJson());
            String fileName = URLEncoder.encode(definitionModel.getName(), "UTF-8").replaceAll("\\+", "%20") + ".dmn";
            response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + fileName);
            ServletOutputStream servletOutputStream = response.getOutputStream();
            response.setContentType("application/xml");
            DmnDefinition dmnDefinition = this.dmnJsonConverter.convertToDmn(editorJsonNode, definitionModel.getId(), converterContext);
            byte[] xmlBytes = this.dmnXmlConverter.convertToXML(dmnDefinition);
            BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(xmlBytes));
            byte[] buffer = new byte[8096];
            while ((count = in.read(buffer)) != -1) {
                servletOutputStream.write(buffer, 0, count);
            }
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (Exception e) {
            LOGGER.error("Could not export decision table model", (Throwable)e);
            throw new InternalServerErrorException("Could not export decision table model");
        }
    }

    public ModelRepresentation importDecisionService(HttpServletRequest request, MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (fileName != null && (fileName.endsWith(".dmn") || fileName.endsWith(".xml"))) {
            try {
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                InputStreamReader xmlIn = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
                XMLStreamReader xtr = xif.createXMLStreamReader(xmlIn);
                DmnDefinition dmnDefinition = this.dmnXmlConverter.convertToDmnModel(xtr);
                if (dmnDefinition.getDecisions().size() == 0) {
                    throw new FlowableException("No decisions found in " + fileName);
                }
                ObjectNode editorJsonNode = this.dmnJsonConverter.convertToJson(dmnDefinition);
                editorJsonNode.remove("id");
                ModelRepresentation modelRepresentation = new ModelRepresentation();
                modelRepresentation.setKey(((Decision)dmnDefinition.getDecisions().get(0)).getId());
                modelRepresentation.setName(dmnDefinition.getName());
                modelRepresentation.setDescription(dmnDefinition.getDescription());
                modelRepresentation.setModelType(4);
                Model model = this.modelService.createModel(modelRepresentation, editorJsonNode.toString(), SecurityUtils.getCurrentUserId());
                return new ModelRepresentation(model);
            }
            catch (Exception e) {
                LOGGER.error("Could not import decision table model", (Throwable)e);
                throw new InternalServerErrorException("Could not import decision table model");
            }
        }
        throw new BadRequestException("Invalid file name, only .dmn or .xml files are supported not " + fileName);
    }

    protected String makeValidFilterText(String filterText) {
        String trimmed;
        String validFilter = null;
        if (filterText != null && (trimmed = StringUtils.trim((String)filterText)).length() >= 1) {
            validFilter = "%" + trimmed.toLowerCase() + "%";
        }
        return validFilter;
    }

    public Model getDecisionServiceModel(String decisionTableId) {
        Model decisionTableModel = this.getModel(decisionTableId, true, false);
        DecisionTableModelConversionUtil.convertModel(decisionTableModel);
        return decisionTableModel;
    }

    public DecisionServiceRepresentation getDecisionService(String decisionTableId) {
        return this.createDecisionServiceRepresentation(this.getDecisionServiceModel(decisionTableId));
    }

    public DecisionServiceRepresentation getDecisionTableRepresentation(AbstractModel decisionTableModel) {
        return this.createDecisionServiceRepresentation(decisionTableModel);
    }

    public DecisionServiceRepresentation getHistoricDecisionService(String modelHistoryId) {
        ModelHistory modelHistory = this.modelHistoryRepository.get(modelHistoryId);
        this.getModel(modelHistory.getModelId(), true, false);
        return this.createDecisionServiceRepresentation(modelHistory);
    }

    protected DecisionServiceRepresentation createDecisionServiceRepresentation(AbstractModel model) {
        DecisionServiceRepresentation result = new DecisionServiceRepresentation(model);
        return result;
    }
}

