/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.zip.ZipInputStream;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDeploymentBuilder;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.common.tenant.TenantProvider;
import org.flowable.ui.modeler.domain.AppDefinition;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.service.BaseAppDefinitionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AppDefinitionPublishService
extends BaseAppDefinitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppDefinitionPublishService.class);
    protected AppRepositoryService appRepositoryService;
    @Autowired
    protected TenantProvider tenantProvider;

    public AppDefinitionPublishService(ObjectProvider<AppRepositoryService> appRepositoryService) {
        this.appRepositoryService = (AppRepositoryService)appRepositoryService.getIfAvailable();
    }

    public void publishAppDefinition(String comment, Model appDefinitionModel, String userId) {
        byte[] deployZipArtifact;
        if (this.appRepositoryService == null) {
            throw new FlowableIllegalStateException("Cannot publish apps from a standalone Modeler application");
        }
        this.modelService.createNewModelVersion(appDefinitionModel, comment, userId);
        AppDefinition appDefinition = null;
        try {
            appDefinition = this.resolveAppDefinition(appDefinitionModel);
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing app {}", (Object)appDefinitionModel.getId(), (Object)e);
            throw new InternalServerErrorException("Could not deserialize app definition");
        }
        if (appDefinition != null && (deployZipArtifact = this.createDeployableZipArtifact(appDefinitionModel, appDefinition)) != null) {
            this.deployZipArtifact(deployZipArtifact, appDefinitionModel.getKey(), appDefinitionModel.getName());
        }
    }

    protected void deployZipArtifact(byte[] zipArtifact, String deploymentKey, String deploymentName) {
        AppDeploymentBuilder deploymentBuilder = this.appRepositoryService.createDeployment().key(deploymentKey).name(deploymentName);
        String tenantId = this.tenantProvider.getTenantId();
        if (tenantId != null) {
            deploymentBuilder.tenantId(tenantId);
        }
        try (ByteArrayInputStream bytesStream = new ByteArrayInputStream(zipArtifact);
             ZipInputStream zipStream = new ZipInputStream(bytesStream);){
            deploymentBuilder.addZipInputStream(zipStream);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to read bytes", ex);
        }
        deploymentBuilder.deploy();
    }
}

