/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.dmn.editor.converter.DmnJsonConverterContext;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.AppDefinition;
import org.flowable.ui.modeler.domain.AppModelDefinition;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.model.AppDefinitionRepresentation;
import org.flowable.ui.modeler.service.BaseAppDefinitionService;
import org.flowable.ui.modeler.service.ConverterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.UriUtils;

@Service
@Transactional
public class AppDefinitionExportService
extends BaseAppDefinitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppDefinitionExportService.class);
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();

    public void exportAppDefinition(HttpServletResponse response, String modelId) throws IOException {
        if (modelId == null) {
            throw new BadRequestException("No application definition id provided");
        }
        Model appModel = this.modelService.getModel(modelId);
        AppDefinitionRepresentation appRepresentation = this.createAppDefinitionRepresentation(appModel);
        this.createAppDefinitionZip(response, appModel, appRepresentation);
    }

    public void exportDeployableAppDefinition(HttpServletResponse response, String modelId) throws IOException {
        if (modelId == null) {
            throw new BadRequestException("No application definition id provided");
        }
        Model appModel = this.modelService.getModel(modelId);
        AppDefinitionRepresentation appRepresentation = this.createAppDefinitionRepresentation(appModel);
        this.createAppDefinitionBar(response, appModel, appRepresentation);
    }

    protected void createAppDefinitionZip(HttpServletResponse response, Model appModel, AppDefinitionRepresentation appDefinition) {
        try {
            Collection<Model> allFormModels;
            Collection<Model> allCaseModels;
            Collection<Model> allProcessModels;
            List<AppModelDefinition> cmmnModelDefinitions;
            response.setHeader("Content-Disposition", "attachment; filename=\"" + appDefinition.getName() + ".zip\"; filename*=utf-8''" + UriUtils.encode((String)(appDefinition.getName() + ".zip"), (String)"utf-8"));
            ServletOutputStream servletOutputStream = response.getOutputStream();
            response.setContentType("application/zip");
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)servletOutputStream);
            this.createZipEntry(zipOutputStream, appModel.getName() + ".json", this.createModelEntryJson(appModel));
            ConverterContext converterContext = new ConverterContext(this.modelService, this.objectMapper);
            List<AppModelDefinition> modelDefinitions = appDefinition.getDefinition().getModels();
            if (CollectionUtils.isNotEmpty(modelDefinitions)) {
                this.createBpmnZipEntries(modelDefinitions, zipOutputStream, converterContext);
            }
            if (CollectionUtils.isNotEmpty(cmmnModelDefinitions = appDefinition.getDefinition().getCmmnModels())) {
                this.createCmmnZipEntries(cmmnModelDefinitions, zipOutputStream, converterContext);
            }
            if ((allProcessModels = converterContext.getAllProcessModels()) != null) {
                this.createBpmnZipEntries(allProcessModels, zipOutputStream, converterContext);
            }
            if ((allCaseModels = converterContext.getAllCaseModels()) != null) {
                this.createCmmnZipEntries(allCaseModels, zipOutputStream, converterContext);
            }
            if ((allFormModels = converterContext.getAllFormModels()) != null) {
                for (Model formModel : allFormModels) {
                    this.createZipEntries(formModel, "form-models", zipOutputStream);
                }
            }
            Collection<Model> allDirectDecisionTableModels = converterContext.getAllDecisionTableModels();
            Collection<Model> allReferencedDecisionTableModels = converterContext.getAllReferencedDecisionTableModels();
            Collection<Model> allDecisionServiceModels = converterContext.getAllDecisionServiceModels();
            allReferencedDecisionTableModels.forEach(referencedDecisionTableModel -> converterContext.getDecisionTableKeyToJsonStringMap().put(referencedDecisionTableModel.getKey(), referencedDecisionTableModel.getModelEditorJson()));
            Collection<Model> allDecisionTableModels = Stream.of(allDirectDecisionTableModels, allReferencedDecisionTableModels).flatMap(Collection::stream).collect(Collectors.toMap(AbstractModel::getKey, d -> d, (x, y) -> x)).values();
            this.createDecisionTableZipEntries(allDecisionTableModels, converterContext, zipOutputStream);
            this.createDecisionServiceZipEntries(allDecisionServiceModels, converterContext, zipOutputStream);
            zipOutputStream.close();
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (Exception e) {
            LOGGER.error("Could not generate app definition zip archive", (Throwable)e);
            throw new InternalServerErrorException("Could not generate app definition zip archive");
        }
    }

    protected void createDecisionTableZipEntries(Collection<Model> decisionTableModels, ConverterContext converterContext, ZipOutputStream zipOutputStream) throws Exception {
        for (Model decisionTableModel : decisionTableModels) {
            this.createZipEntries(decisionTableModel, "decision-table-models", zipOutputStream);
            try {
                JsonNode decisionTableNode = this.objectMapper.readTree(decisionTableModel.getModelEditorJson());
                DmnDefinition dmnDefinition = this.dmnJsonConverter.convertToDmn(decisionTableNode, decisionTableModel.getId());
                byte[] dmnXMLBytes = this.dmnXMLConverter.convertToXML(dmnDefinition);
                this.createZipEntry(zipOutputStream, "decision-table-models/" + decisionTableModel.getKey() + ".dmn", dmnXMLBytes);
            }
            catch (Exception e) {
                throw new InternalServerErrorException(String.format("Error converting decision table %s to XML", decisionTableModel.getName()));
            }
        }
    }

    protected void createDecisionServiceZipEntries(Collection<Model> decisionServiceModels, ConverterContext converterContext, ZipOutputStream zipOutputStream) throws Exception {
        for (Model decisionServiceModel : decisionServiceModels) {
            this.createZipEntries(decisionServiceModel, "decision-service-models", zipOutputStream);
            try {
                JsonNode decisionServiceNode = this.objectMapper.readTree(decisionServiceModel.getModelEditorJson());
                DmnDefinition dmnDefinition = this.dmnJsonConverter.convertToDmn(decisionServiceNode, decisionServiceModel.getId(), (DmnJsonConverterContext)converterContext);
                byte[] dmnXMLBytes = this.dmnXMLConverter.convertToXML(dmnDefinition);
                this.createZipEntry(zipOutputStream, "decision-service-models/" + decisionServiceModel.getKey() + ".dmn", dmnXMLBytes);
            }
            catch (Exception e) {
                throw new InternalServerErrorException(String.format("Error converting decision service %s to XML", decisionServiceModel.getName()));
            }
        }
    }

    public void createAppDefinitionBar(HttpServletResponse response, Model appModel, AppDefinitionRepresentation appDefinition) {
        try {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + appDefinition.getName() + ".bar\"; filename*=utf-8''" + UriUtils.encode((String)(appDefinition.getName() + ".bar"), (String)"utf-8"));
            byte[] deployZipArtifact = this.createDeployableZipArtifact(appModel, appDefinition.getDefinition());
            ServletOutputStream servletOutputStream = response.getOutputStream();
            response.setContentType("application/zip");
            servletOutputStream.write(deployZipArtifact);
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (Exception e) {
            LOGGER.error("Could not generate app definition bar archive", (Throwable)e);
            throw new InternalServerErrorException("Could not generate app definition bar archive");
        }
    }

    protected void createBpmnZipEntries(List<AppModelDefinition> modelDefinitions, ZipOutputStream zipOutputStream, ConverterContext converterContext) throws Exception {
        for (AppModelDefinition modelDef : modelDefinitions) {
            Model model = this.modelService.getModel(modelDef.getId());
            List<Model> referencedModels = this.modelRepository.findByParentModelId(model.getId());
            for (Model childModel : referencedModels) {
                if (2 == childModel.getModelType()) {
                    converterContext.addFormModel(childModel);
                    continue;
                }
                if (4 == childModel.getModelType()) {
                    converterContext.addDecisionTableModel(childModel);
                    continue;
                }
                if (6 != childModel.getModelType()) continue;
                converterContext.addDecisionServiceModel(childModel);
                List<Model> referencedDecisionTableModels = this.modelRepository.findByParentModelId(childModel.getId());
                referencedDecisionTableModels.stream().filter(refModel -> 4 == refModel.getModelType()).forEach(converterContext::addReferencedDecisionTableModel);
            }
            BpmnModel bpmnModel = this.modelService.getBpmnModel(model, converterContext);
            HashMap<String, StartEvent> noneStartEventMap = new HashMap<String, StartEvent>();
            this.postProcessFlowElements(new ArrayList<FlowElement>(), noneStartEventMap, bpmnModel);
            for (Process process : bpmnModel.getProcesses()) {
                this.processUserTasks(process.getFlowElements(), process, noneStartEventMap);
            }
            byte[] modelXML = this.modelService.getBpmnXML(bpmnModel);
            this.createZipEntry(zipOutputStream, "bpmn-models/" + model.getKey().replaceAll(" ", "") + ".bpmn", modelXML);
            this.createZipEntries(model, "bpmn-models", zipOutputStream);
        }
    }

    protected void createBpmnZipEntries(Collection<Model> models, ZipOutputStream zipOutputStream, ConverterContext converterContext) throws Exception {
        for (Model model : models) {
            BpmnModel bpmnModel = this.modelService.getBpmnModel(model, converterContext);
            HashMap<String, StartEvent> noneStartEventMap = new HashMap<String, StartEvent>();
            this.postProcessFlowElements(new ArrayList<FlowElement>(), noneStartEventMap, bpmnModel);
            for (Process process : bpmnModel.getProcesses()) {
                this.processUserTasks(process.getFlowElements(), process, noneStartEventMap);
            }
            byte[] modelXML = this.modelService.getBpmnXML(bpmnModel);
            this.createZipEntry(zipOutputStream, "bpmn-models/" + model.getKey().replaceAll(" ", "") + ".bpmn", modelXML);
            this.createZipEntries(model, "bpmn-models", zipOutputStream);
        }
    }

    protected void createCmmnZipEntries(List<AppModelDefinition> modelDefinitions, ZipOutputStream zipOutputStream, ConverterContext converterContext) throws Exception {
        for (AppModelDefinition modelDef : modelDefinitions) {
            Model model = this.modelService.getModel(modelDef.getId());
            List<Model> referencedModels = this.modelRepository.findByParentModelId(model.getId());
            for (Model childModel : referencedModels) {
                if (2 == childModel.getModelType()) {
                    converterContext.addFormModel(childModel);
                    continue;
                }
                if (4 == childModel.getModelType()) {
                    converterContext.addDecisionTableModel(childModel);
                    continue;
                }
                if (6 == childModel.getModelType()) {
                    converterContext.addDecisionServiceModel(childModel);
                    continue;
                }
                if (0 == childModel.getModelType()) {
                    converterContext.addProcessModel(childModel);
                    continue;
                }
                if (5 != childModel.getModelType()) continue;
                converterContext.addCaseModel(childModel);
            }
            CmmnModel cmmnModel = this.modelService.getCmmnModel(model, converterContext);
            byte[] modelXML = this.modelService.getCmmnXML(cmmnModel);
            this.createZipEntry(zipOutputStream, "cmmn-models/" + model.getKey().replaceAll(" ", "") + ".cmmn", modelXML);
            this.createZipEntries(model, "cmmn-models", zipOutputStream);
        }
    }

    protected void createCmmnZipEntries(Collection<Model> models, ZipOutputStream zipOutputStream, ConverterContext converterContext) throws Exception {
        for (Model model : models) {
            CmmnModel cmmnModel = this.modelService.getCmmnModel(model, converterContext);
            byte[] modelXML = this.modelService.getCmmnXML(cmmnModel);
            this.createZipEntry(zipOutputStream, "cmmn-models/" + model.getKey().replaceAll(" ", "") + ".cmmn", modelXML);
            this.createZipEntries(model, "cmmn-models", zipOutputStream);
        }
    }

    protected void createZipEntries(Model model, String directoryName, ZipOutputStream zipOutputStream) throws Exception {
        this.createZipEntry(zipOutputStream, directoryName + "/" + model.getKey() + ".json", this.createModelEntryJson(model));
        if (model.getThumbnail() != null) {
            this.createZipEntry(zipOutputStream, directoryName + "/" + model.getKey() + ".png", model.getThumbnail());
        }
    }

    protected String createModelEntryJson(Model model) {
        ObjectNode modelJson = this.objectMapper.createObjectNode();
        modelJson.put("id", model.getId());
        modelJson.put("name", model.getName());
        modelJson.put("key", model.getKey());
        modelJson.put("description", model.getDescription());
        try {
            modelJson.set("editorJson", this.objectMapper.readTree(model.getModelEditorJson()));
        }
        catch (Exception e) {
            LOGGER.error("Error exporting model json for id {}", (Object)model.getId(), (Object)e);
            throw new InternalServerErrorException("Error exporting model json for id " + model.getId());
        }
        return modelJson.toString();
    }

    protected AppDefinitionRepresentation createAppDefinitionRepresentation(AbstractModel model) {
        AppDefinition appDefinition = null;
        try {
            appDefinition = (AppDefinition)this.objectMapper.readValue(model.getModelEditorJson(), AppDefinition.class);
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing app {}", (Object)model.getId(), (Object)e);
            throw new InternalServerErrorException("Could not deserialize app definition");
        }
        AppDefinitionRepresentation result = new AppDefinitionRepresentation(model);
        result.setDefinition(appDefinition);
        return result;
    }

    protected void createZipEntry(ZipOutputStream zipOutputStream, String filename, String content) throws Exception {
        this.createZipEntry(zipOutputStream, filename, content.getBytes(StandardCharsets.UTF_8));
    }

    protected void createZipEntry(ZipOutputStream zipOutputStream, String filename, byte[] content) throws Exception {
        ZipEntry entry = new ZipEntry(filename);
        zipOutputStream.putNextEntry(entry);
        zipOutputStream.write(content);
        zipOutputStream.closeEntry();
    }
}

