/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.security;

import java.util.ArrayList;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.ui.common.model.RemoteUser;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class RemoteIdmAuthenticationProvider
implements AuthenticationProvider {
    @Autowired
    protected RemoteIdmService remoteIdmService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        RemoteUser user = this.remoteIdmService.authenticateUser(authentication.getPrincipal().toString(), authentication.getCredentials().toString());
        if (user == null) {
            throw new FlowableException("user not found " + authentication.getPrincipal());
        }
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        for (String privilege : user.getPrivileges()) {
            grantedAuthorities.add(new SimpleGrantedAuthority(privilege));
        }
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), grantedAuthorities);
        return auth;
    }

    public boolean supports(Class<?> authentication) {
        return true;
    }
}

