/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.ProcessEngineInfoService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessEngineInfoClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessEngineInfoClientResource.class);
    @Autowired
    protected ProcessEngineInfoService clientService;

    @GetMapping(value={"/rest/admin/engine-info/{endpointTypeCode}"})
    public JsonNode getEngineInfo(@PathVariable Integer endpointTypeCode) throws BadRequestException {
        EndpointType endpointType = EndpointType.valueOf((int)endpointTypeCode);
        if (endpointType == null) {
            throw new BadRequestException("No valid endpoint type code provided: " + endpointTypeCode);
        }
        try {
            return this.clientService.getEngineInfo(this.retrieveServerConfig(endpointType));
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting engine info {}", (Object)endpointType, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }
}

