/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.DecisionHistoricExecutionService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DecisionTableHistoricExecutionClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecisionTableHistoricExecutionClientResource.class);
    @Autowired
    protected DecisionHistoricExecutionService clientService;

    @GetMapping(value={"/rest/admin/decision-tables/history/{executionId}"}, produces={"application/json"})
    public JsonNode getDecisionTableHistoricExecution(@PathVariable String executionId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.DMN);
        try {
            return this.clientService.getHistoricDecisionExecution(serverConfig, executionId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting historic decision table execution {}", (Object)executionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/decision-tables/history/{executionId}/auditdata"}, produces={"application/json"})
    public JsonNode getDecisionTableHistoricExecutionAuditData(@PathVariable String executionId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.DMN);
        try {
            return this.clientService.getHistoricDecisionExecutionAuditData(serverConfig, executionId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting historic decision table execution {}", (Object)executionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }
}

