/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.ContentItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ContentItemsClientResource
extends AbstractClientResource {
    @Autowired
    protected ContentItemService clientService;
    @Autowired
    protected ObjectMapper objectMapper;

    @GetMapping(value={"/rest/admin/content-items"}, produces={"application/json"})
    public JsonNode listFormDefinitions(HttpServletRequest request) {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CONTENT);
        Map<String, String[]> parameterMap = this.getRequestParametersWithoutServerId(request);
        return this.clientService.listContentItems(serverConfig, parameterMap);
    }

    @GetMapping(value={"/rest/admin/process-instance-content-items/{processInstanceId}"}, produces={"application/json"})
    public JsonNode getProcessDefinitionForms(@PathVariable String processInstanceId, HttpServletRequest request) {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CONTENT);
        Map<String, String[]> parameterMap = this.getRequestParametersWithoutServerId(request);
        String[] processInstanceIds = new String[]{processInstanceId};
        parameterMap.put("processInstanceId", processInstanceIds);
        return this.clientService.listContentItems(serverConfig, parameterMap);
    }
}

