/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.CaseInstanceService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CaseInstanceClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseInstanceClientResource.class);
    @Autowired
    protected CaseInstanceService clientService;

    @GetMapping(value={"/rest/admin/case-instances/{caseInstanceId}"}, produces={"application/json"})
    public JsonNode getProcessInstance(@PathVariable String caseInstanceId, @RequestParam(required=false, defaultValue="false") boolean runtime) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            return this.clientService.getCaseInstance(serverConfig, caseInstanceId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting case instance {}", (Object)caseInstanceId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/case-instances/{caseInstanceId}/tasks"})
    public JsonNode getSubtasks(@PathVariable String caseInstanceId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            return this.clientService.getTasks(serverConfig, caseInstanceId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting tasks for case instance {}", (Object)caseInstanceId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/case-instances/{caseInstanceId}/variables"})
    public JsonNode getVariables(@PathVariable String caseInstanceId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            return this.clientService.getVariables(serverConfig, caseInstanceId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting variables for case instance {}", (Object)caseInstanceId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @PutMapping(value={"/rest/admin/case-instances/{caseInstanceId}/variables/{variableName}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateVariable(@PathVariable String caseInstanceId, @PathVariable String variableName, @RequestBody ObjectNode body) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            this.clientService.updateVariable(serverConfig, caseInstanceId, variableName, body);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error updating variable {} for case instance {}", new Object[]{variableName, caseInstanceId, e});
            throw new BadRequestException(e.getMessage());
        }
    }

    @PostMapping(value={"/rest/admin/case-instances/{caseInstanceId}/variables"})
    @ResponseStatus(value=HttpStatus.OK)
    public void createVariable(@PathVariable String caseInstanceId, @RequestBody ObjectNode body) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            this.clientService.createVariable(serverConfig, caseInstanceId, body);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error creating variable for case instance {}", (Object)caseInstanceId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @DeleteMapping(value={"/rest/admin/case-instances/{caseInstanceId}/variables/{variableName}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteVariable(@PathVariable String caseInstanceId, @PathVariable String variableName) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            this.clientService.deleteVariable(serverConfig, caseInstanceId, variableName);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error deleting variable for case instance {}", (Object)caseInstanceId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/case-instances/{caseInstanceId}/jobs"})
    public JsonNode getJobs(@PathVariable String caseInstanceId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            return this.clientService.getJobs(serverConfig, caseInstanceId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting jobs for case instance {}", (Object)caseInstanceId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @PostMapping(value={"/rest/admin/case-instances/{caseInstanceId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void executeAction(@PathVariable String caseInstanceId, @RequestBody JsonNode actionBody) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            this.clientService.executeAction(serverConfig, caseInstanceId, actionBody);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error executing action on case instance {}", (Object)caseInstanceId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/case-instances/{caseInstanceId}/decision-executions"})
    public JsonNode getDecisionExecutions(@PathVariable String caseInstanceId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.DMN);
        try {
            return this.clientService.getDecisionExecutions(serverConfig, caseInstanceId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting decision executions {}", (Object)caseInstanceId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @PostMapping(value={"/rest/admin/case-instances/{caseInstanceId}/change-state"})
    @ResponseStatus(value=HttpStatus.OK)
    public void changePlanItemState(@PathVariable String caseInstanceId, @RequestBody JsonNode changeStateBody) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            this.clientService.changePlanItemState(serverConfig, caseInstanceId, changeStateBody);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error changing plan item state for case instance {}", (Object)caseInstanceId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @PostMapping(value={"/rest/admin/case-instances/{caseInstanceId}/migrate"})
    @ResponseStatus(value=HttpStatus.OK)
    public void migrateProcessInstance(@PathVariable String caseInstanceId, @RequestBody String migrationDocument) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            this.clientService.migrateCaseInstance(serverConfig, caseInstanceId, migrationDocument);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error migrating case instance {}", (Object)caseInstanceId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }
}

