/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.BatchService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BatchPartClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchPartClientResource.class);
    @Autowired
    protected BatchService clientService;

    @GetMapping(value={"/rest/admin/batch-parts/{batchPartId}"}, produces={"application/json"})
    public JsonNode getBatchPart(@PathVariable String batchPartId, HttpServletRequest request) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        try {
            return this.clientService.getBatchPart(serverConfig, batchPartId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting batch part {}", (Object)batchPartId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/batch-parts/{batchPartId}/batch-part-document"}, produces={"text/plain"})
    public String getBatchPartDocument(@PathVariable String batchPartId, HttpServletRequest request) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        try {
            return this.clientService.getBatchPartDocument(serverConfig, batchPartId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting batch part document {}", (Object)batchPartId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }
}

