/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.AppDeploymentService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/admin/app-deployments"})
public class AppDeploymentsClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppDeploymentsClientResource.class);
    @Autowired
    protected AppDeploymentService clientService;

    @GetMapping(produces={"application/json"})
    public JsonNode listAppDeployments(HttpServletRequest request) {
        LOGGER.debug("REST request to get a list of app deployments");
        JsonNode resultNode = null;
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.APP);
        Map<String, String[]> parameterMap = this.getRequestParametersWithoutServerId(request);
        try {
            resultNode = this.clientService.listDeployments(serverConfig, parameterMap);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting app deployments", (Throwable)e);
            throw new BadRequestException(e.getMessage());
        }
        return resultNode;
    }

    @PostMapping(produces={"application/json"})
    public JsonNode handleAppFileUpload(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        if (!file.isEmpty()) {
            try {
                ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.APP);
                String fileName = file.getOriginalFilename();
                if (fileName != null && (fileName.endsWith(".app") || fileName.endsWith(".zip") || fileName.endsWith(".bar"))) {
                    return this.clientService.uploadDeployment(serverConfig, fileName, file.getInputStream());
                }
                LOGGER.error("Invalid app deployment file name {}", (Object)fileName);
                throw new BadRequestException("Invalid file name");
            }
            catch (IOException e) {
                LOGGER.error("Error deploying app upload", (Throwable)e);
                throw new InternalServerErrorException("Could not deploy file: " + e.getMessage());
            }
        }
        LOGGER.error("No app deployment file found in request");
        throw new BadRequestException("No file found in POST body");
    }
}

