/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.dto.ServerConfigRepresentation;
import org.flowable.ui.admin.service.engine.ServerConfigService;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ServerConfigsResource {
    @Autowired
    protected ServerConfigService serverConfigService;

    @GetMapping(value={"/rest/server-configs"}, produces={"application/json"})
    public List<ServerConfigRepresentation> getServers() {
        return this.serverConfigService.findAll();
    }

    @GetMapping(value={"/rest/server-configs/default/{endpointTypeCode}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ServerConfigRepresentation getDefaultServerConfig(@PathVariable Integer endpointTypeCode) {
        EndpointType endpointType = EndpointType.valueOf((int)endpointTypeCode);
        if (endpointType == null) {
            throw new IllegalArgumentException("Unknown endpoint type code: " + endpointTypeCode);
        }
        return new ServerConfigRepresentation(this.serverConfigService.getDefaultServerConfig(endpointType));
    }

    @PutMapping(value={"/rest/server-configs/{serverId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateServer(@PathVariable String serverId, @RequestBody ServerConfigRepresentation configRepresentation) {
        ServerConfig config = this.serverConfigService.findOne(serverId);
        if (config == null) {
            throw new BadRequestException("Server with id '" + serverId + "' does not exist");
        }
        boolean updatePassword = false;
        if (StringUtils.isNotEmpty((CharSequence)configRepresentation.getPassword())) {
            config.setPassword(configRepresentation.getPassword());
            updatePassword = true;
        } else {
            configRepresentation.setPassword(this.serverConfigService.getServerConfigDecryptedPassword(config));
        }
        config.setContextRoot(configRepresentation.getContextRoot());
        config.setDescription(configRepresentation.getDescription());
        config.setName(configRepresentation.getName());
        config.setPort(configRepresentation.getServerPort());
        config.setRestRoot(configRepresentation.getRestRoot());
        config.setServerAddress(configRepresentation.getServerAddress());
        config.setUserName(configRepresentation.getUserName());
        this.serverConfigService.save(config, updatePassword);
    }

    protected ServerConfigRepresentation createServerConfigRepresentation(ServerConfig serverConfig) {
        ServerConfigRepresentation serverRepresentation = new ServerConfigRepresentation();
        serverRepresentation.setId(serverConfig.getId());
        serverRepresentation.setName(serverConfig.getName());
        serverRepresentation.setDescription(serverConfig.getDescription());
        serverRepresentation.setServerAddress(serverConfig.getServerAddress());
        serverRepresentation.setServerPort(serverConfig.getPort());
        serverRepresentation.setContextRoot(serverConfig.getContextRoot());
        serverRepresentation.setRestRoot(serverConfig.getRestRoot());
        serverRepresentation.setUserName(serverConfig.getUserName());
        return serverRepresentation;
    }
}

