/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.repository;

import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.Model;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseModelResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected Model getModelFromRequest(String modelId) {
        Model model = (Model)this.repositoryService.createModelQuery().modelId(modelId).singleResult();
        if (model == null) {
            throw new FlowableObjectNotFoundException("Could not find a model with id '" + modelId + "'.", ProcessDefinition.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessModelInfoById(model);
        }
        return model;
    }
}

