/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.history;

import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.common.rest.api.RequestUtil;
import org.flowable.engine.HistoryService;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.history.HistoricTaskLogEntryQueryRequest;
import org.flowable.rest.service.api.history.HistoricTaskLogEntryResponse;
import org.flowable.task.api.history.HistoricTaskLogEntryQuery;
import org.flowable.task.service.impl.HistoricTaskLogEntryQueryProperty;
import org.springframework.beans.factory.annotation.Autowired;

public class HistoricTaskLogEntryBaseResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected DataResponse<HistoricTaskLogEntryResponse> getQueryResponse(HistoricTaskLogEntryQueryRequest request, Map<String, String> allRequestParams) {
        HistoricTaskLogEntryQuery query = this.historyService.createHistoricTaskLogEntryQuery();
        if (request.getTaskId() != null) {
            query.taskId(allRequestParams.get("taskId"));
        }
        if (request.getType() != null) {
            query.type(allRequestParams.get("type"));
        }
        if (request.getUserId() != null) {
            query.userId(allRequestParams.get("userId"));
        }
        if (request.getProcessInstanceId() != null) {
            query.processInstanceId(allRequestParams.get("processInstanceId"));
        }
        if (request.getProcessDefinitionId() != null) {
            query.processDefinitionId(allRequestParams.get("processDefinitionId"));
        }
        if (request.getScopeId() != null) {
            query.scopeId(allRequestParams.get("scopeId"));
        }
        if (request.getScopeDefinitionId() != null) {
            query.scopeDefinitionId(allRequestParams.get("scopeDefinitionId"));
        }
        if (request.getSubScopeId() != null) {
            query.subScopeId(allRequestParams.get("subScopeId"));
        }
        if (request.getScopeType() != null) {
            query.scopeType(allRequestParams.get("scopeType"));
        }
        if (request.getFrom() != null) {
            query.from(RequestUtil.getDate(allRequestParams, (String)"from"));
        }
        if (request.getTo() != null) {
            query.to(RequestUtil.getDate(allRequestParams, (String)"to"));
        }
        if (request.getTenantId() != null) {
            query.tenantId(allRequestParams.get("tenantId"));
        }
        if (request.getFromLogNumber() != null) {
            query.fromLogNumber(Long.parseLong(allRequestParams.get("fromLogNumber")));
        }
        if (request.getToLogNumber() != null) {
            query.toLogNumber(Long.parseLong(allRequestParams.get("toLogNumber")));
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoricTaskLogWithQuery(query, request);
        }
        return PaginateListUtil.paginateList(allRequestParams, (Query)query, (String)"logNumber", allowedSortProperties, this.restResponseFactory::createHistoricTaskLogEntryResponseList);
    }

    static {
        allowedSortProperties.put("logNumber", (QueryProperty)HistoricTaskLogEntryQueryProperty.LOG_NUMBER);
        allowedSortProperties.put("timeStamp", (QueryProperty)HistoricTaskLogEntryQueryProperty.TIME_STAMP);
    }
}

