/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.flowable.rest.service.api.identity;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author Frederik Heremans
 */
public class UserInfoRequest {

    protected String key;
    protected String value;

    public void setKey(String key) {
        this.key = key;
    }

    @ApiModelProperty(example = "jobTitle")
    public String getKey() {
        return key;
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    public void setValue(String value) {
        this.value = value;
    }

    @ApiModelProperty(example = "Muppet")
    public String getValue() {
        return value;
    }
}
