/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CancelEventDefinition;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.bpmn.model.Transaction;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class BoundaryEventValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class);
        HashMap<String, Integer> cancelBoundaryEventsCounts = new HashMap<String, Integer>();
        HashMap<String, Integer> compensateBoundaryEventsCounts = new HashMap<String, Integer>();
        for (int i = 0; i < boundaryEvents.size(); ++i) {
            String eventTypeValue;
            BoundaryEvent boundaryEvent = (BoundaryEvent)boundaryEvents.get(i);
            if (boundaryEvent.getEventDefinitions() != null && !boundaryEvent.getEventDefinitions().isEmpty()) {
                EventDefinition eventDefinition = (EventDefinition)boundaryEvent.getEventDefinitions().get(0);
                if (!(eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof ErrorEventDefinition || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof CancelEventDefinition || eventDefinition instanceof MessageEventDefinition || eventDefinition instanceof ConditionalEventDefinition || eventDefinition instanceof CompensateEventDefinition || eventDefinition instanceof EscalationEventDefinition)) {
                    this.addError(errors, "flowable-boundary-event-invalid-event-definition", process, (BaseElement)boundaryEvent, "Invalid or unsupported event definition");
                }
                if (eventDefinition instanceof CancelEventDefinition) {
                    FlowElement attachedToFlowElement = bpmnModel.getFlowElement(boundaryEvent.getAttachedToRefId());
                    if (!(attachedToFlowElement instanceof Transaction)) {
                        this.addError(errors, "flowable-boundary-event-cancel-only-on-transaction", process, (BaseElement)boundaryEvent, "boundary event with cancelEventDefinition only supported on transaction subprocesses");
                        continue;
                    }
                    if (!cancelBoundaryEventsCounts.containsKey(attachedToFlowElement.getId())) {
                        cancelBoundaryEventsCounts.put(attachedToFlowElement.getId(), 0);
                    }
                    cancelBoundaryEventsCounts.put(attachedToFlowElement.getId(), (Integer)cancelBoundaryEventsCounts.get(attachedToFlowElement.getId()) + 1);
                    continue;
                }
                if (eventDefinition instanceof CompensateEventDefinition) {
                    if (!compensateBoundaryEventsCounts.containsKey(boundaryEvent.getAttachedToRefId())) {
                        compensateBoundaryEventsCounts.put(boundaryEvent.getAttachedToRefId(), 0);
                    }
                    compensateBoundaryEventsCounts.put(boundaryEvent.getAttachedToRefId(), (Integer)compensateBoundaryEventsCounts.get(boundaryEvent.getAttachedToRefId()) + 1);
                    continue;
                }
                if (!(eventDefinition instanceof MessageEventDefinition)) continue;
                for (int j = 0; j < boundaryEvents.size(); ++j) {
                    EventDefinition otherEventDefinition;
                    BoundaryEvent otherBoundaryEvent;
                    if (j == i || (otherBoundaryEvent = (BoundaryEvent)boundaryEvents.get(j)).getAttachedToRefId() == null || !otherBoundaryEvent.getAttachedToRefId().equals(boundaryEvent.getAttachedToRefId()) || otherBoundaryEvent.getEventDefinitions() == null || otherBoundaryEvent.getEventDefinitions().isEmpty() || !((otherEventDefinition = (EventDefinition)otherBoundaryEvent.getEventDefinitions().get(0)) instanceof MessageEventDefinition)) continue;
                    MessageEventDefinition currentMessageEventDefinition = (MessageEventDefinition)eventDefinition;
                    MessageEventDefinition otherMessageEventDefinition = (MessageEventDefinition)otherEventDefinition;
                    if (otherMessageEventDefinition.getMessageRef() == null || !otherMessageEventDefinition.getMessageRef().equals(currentMessageEventDefinition.getMessageRef())) continue;
                    this.addError(errors, "flowable-message-event-multiple-on-boundary-same-message-id", process, (BaseElement)boundaryEvent, "Multiple message events with same message id not supported");
                }
                continue;
            }
            boolean isEventRegistryBoundaryEvent = false;
            List eventTypeExtensionElements = (List)boundaryEvent.getExtensionElements().get("eventType");
            if (eventTypeExtensionElements != null && !eventTypeExtensionElements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(eventTypeValue = ((ExtensionElement)eventTypeExtensionElements.get(0)).getElementText()))) {
                isEventRegistryBoundaryEvent = true;
            }
            if (isEventRegistryBoundaryEvent) continue;
            this.addError(errors, "flowable-boundary-event-no-event-definition", process, (BaseElement)boundaryEvent, "Event definition is missing from boundary event");
        }
        for (String elementId : cancelBoundaryEventsCounts.keySet()) {
            if ((Integer)cancelBoundaryEventsCounts.get(elementId) <= 1) continue;
            this.addError(errors, "flowable-boundary-event-multiple-cancel-on-transaction", process, (BaseElement)bpmnModel.getFlowElement(elementId), "multiple boundary events with cancelEventDefinition not supported on same transaction subprocess.");
        }
        for (String elementId : compensateBoundaryEventsCounts.keySet()) {
            if ((Integer)compensateBoundaryEventsCounts.get(elementId) <= 1) continue;
            this.addError(errors, "flowable-compensate-event-multiple-on-boundary", process, (BaseElement)bpmnModel.getFlowElement(elementId), "Multiple boundary events of type 'compensate' is invalid");
        }
    }
}

