/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class SequenceflowValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List sequenceFlows = process.findFlowElementsOfType(SequenceFlow.class);
        for (SequenceFlow sequenceFlow : sequenceFlows) {
            String sourceRef = sequenceFlow.getSourceRef();
            String targetRef = sequenceFlow.getTargetRef();
            if (StringUtils.isEmpty((CharSequence)sourceRef)) {
                this.addError(errors, "flowable-seq-flow-invalid-src", process, (BaseElement)sequenceFlow, "Invalid source for sequenceflow");
            }
            if (StringUtils.isEmpty((CharSequence)targetRef)) {
                this.addError(errors, "flowable-seq-flow-invalid-target", process, (BaseElement)sequenceFlow, "Invalid target for sequenceflow");
            }
            FlowElement source = process.getFlowElement(sourceRef, true);
            FlowElement target = process.getFlowElement(targetRef, true);
            if (source == null) {
                this.addError(errors, "flowable-seq-flow-invalid-src", process, (BaseElement)sequenceFlow, "Invalid source for sequenceflow");
            }
            if (target == null) {
                this.addError(errors, "flowable-seq-flow-invalid-target", process, (BaseElement)sequenceFlow, "Invalid target for sequenceflow");
            }
            if (source == null || target == null) continue;
            FlowElementsContainer sourceContainer = process.getFlowElementsContainer(source.getId());
            FlowElementsContainer targetContainer = process.getFlowElementsContainer(target.getId());
            if (sourceContainer == null) {
                this.addError(errors, "flowable-seq-flow-invalid-src", process, (BaseElement)sequenceFlow, "Invalid source for sequenceflow");
            }
            if (targetContainer == null) {
                this.addError(errors, "flowable-seq-flow-invalid-target", process, (BaseElement)sequenceFlow, "Invalid target for sequenceflow");
            }
            if (sourceContainer == null || targetContainer == null || sourceContainer.equals(targetContainer)) continue;
            this.addError(errors, "flowable-seq-flow-invalid-target", process, (BaseElement)sequenceFlow, "Invalid target for sequenceflow, the target isn't defined in the same scope as the source");
        }
    }
}

