/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;

public class StartEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        StartEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        StartEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("StartNoneEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartTimerEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartConditionalEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartErrorEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartEscalationEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartMessageEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartEventRegistryEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartSignalEvent", StartEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(StartEvent.class, StartEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        String eventType;
        Event event = (Event)baseElement;
        if (event.getEventDefinitions().size() > 0) {
            EventDefinition eventDefinition = (EventDefinition)event.getEventDefinitions().get(0);
            if (eventDefinition instanceof TimerEventDefinition) {
                return "StartTimerEvent";
            }
            if (eventDefinition instanceof ConditionalEventDefinition) {
                return "StartConditionalEvent";
            }
            if (eventDefinition instanceof ErrorEventDefinition) {
                return "StartErrorEvent";
            }
            if (eventDefinition instanceof EscalationEventDefinition) {
                return "StartEscalationEvent";
            }
            if (eventDefinition instanceof MessageEventDefinition) {
                return "StartMessageEvent";
            }
            if (eventDefinition instanceof SignalEventDefinition) {
                return "StartSignalEvent";
            }
        } else if (event.getExtensionElements().get("eventType") != null && ((List)event.getExtensionElements().get("eventType")).size() > 0 && StringUtils.isNotEmpty((CharSequence)(eventType = ((ExtensionElement)((List)event.getExtensionElements().get("eventType")).get(0)).getElementText()))) {
            return "StartEventRegistryEvent";
        }
        return "StartNoneEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement, BpmnJsonConverterContext converterContext) {
        StartEvent startEvent = (StartEvent)baseElement;
        if (StringUtils.isNotEmpty((CharSequence)startEvent.getInitiator())) {
            propertiesNode.put("initiator", startEvent.getInitiator());
        }
        if (StringUtils.isNotEmpty((CharSequence)startEvent.getFormKey())) {
            Map<String, String> modelInfo = converterContext.getFormModelInfoForFormModelKey(startEvent.getFormKey());
            if (modelInfo != null) {
                ObjectNode formRefNode = this.objectMapper.createObjectNode();
                formRefNode.put("id", modelInfo.get("id"));
                formRefNode.put("name", modelInfo.get("name"));
                formRefNode.put("key", modelInfo.get("key"));
                propertiesNode.set("formreference", (JsonNode)formRefNode);
            } else {
                this.setPropertyValue("formkeydefinition", startEvent.getFormKey(), propertiesNode);
            }
        }
        this.setPropertyValue("formfieldvalidation", startEvent.getValidateFormFields(), propertiesNode);
        if (startEvent.getSubProcess() instanceof EventSubProcess && !startEvent.isInterrupting()) {
            propertiesNode.put("interrupting", false);
        } else {
            propertiesNode.put("interrupting", true);
        }
        this.addFormProperties(startEvent.getFormProperties(), propertiesNode);
        this.addEventProperties((Event)startEvent, propertiesNode);
        this.addEventRegistryProperties((FlowElement)startEvent, propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext) {
        StartEvent startEvent = new StartEvent();
        startEvent.setInitiator(this.getPropertyValueAsString("initiator", elementNode));
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("StartNoneEvent".equals(stencilId)) {
            String formKey = this.getPropertyValueAsString("formkeydefinition", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)formKey)) {
                startEvent.setFormKey(formKey);
            } else {
                JsonNode formReferenceNode = this.getProperty("formreference", elementNode);
                if (formReferenceNode != null && formReferenceNode.get("id") != null) {
                    String formModelId = formReferenceNode.get("id").asText();
                    String formModelKey = converterContext.getFormModelKeyForFormModelId(formModelId);
                    if (formModelKey != null) {
                        startEvent.setFormKey(formModelKey);
                    } else {
                        String key = formReferenceNode.get("key").asText();
                        if (StringUtils.isNotEmpty((CharSequence)key)) {
                            startEvent.setFormKey(key);
                        }
                    }
                }
            }
            String validateFormFields = this.getPropertyValueAsString("formfieldvalidation", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)validateFormFields)) {
                startEvent.setValidateFormFields(validateFormFields);
            }
            this.convertJsonToFormProperties(elementNode, (BaseElement)startEvent);
        } else if ("StartTimerEvent".equals(stencilId)) {
            this.convertJsonToTimerDefinition(elementNode, (Event)startEvent);
        } else if ("StartConditionalEvent".equals(stencilId)) {
            this.convertJsonToConditionalDefinition(elementNode, (Event)startEvent);
        } else if ("StartErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, (Event)startEvent);
        } else if ("StartEscalationEvent".equals(stencilId)) {
            this.convertJsonToEscalationDefinition(elementNode, (Event)startEvent);
        } else if ("StartMessageEvent".equals(stencilId)) {
            this.convertJsonToMessageDefinition(elementNode, (Event)startEvent);
        } else if ("StartSignalEvent".equals(stencilId)) {
            this.convertJsonToSignalDefinition(elementNode, (Event)startEvent);
        } else if ("StartEventRegistryEvent".equals(stencilId)) {
            this.addReceiveEventExtensionElements(elementNode, (FlowElement)startEvent);
        }
        if (!this.getPropertyValueAsBoolean("interrupting", elementNode)) {
            startEvent.setInterrupting(false);
        }
        return startEvent;
    }

    @Override
    protected void setPropertyValue(String name, String value, ObjectNode propertiesNode) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            propertiesNode.put(name, value);
        }
    }
}

