/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.flowable.common.spring.AutoDeploymentStrategy;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.flowable.common.spring.SpringTransactionContextFactory;
import org.flowable.common.spring.SpringTransactionInterceptor;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.FormEngines;
import org.flowable.form.engine.impl.cfg.StandaloneFormEngineConfiguration;
import org.flowable.form.spring.autodeployment.DefaultAutoDeploymentStrategy;
import org.flowable.form.spring.autodeployment.ResourceParentFolderAutoDeploymentStrategy;
import org.flowable.form.spring.autodeployment.SingleResourceAutoDeploymentStrategy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringFormEngineConfiguration
extends FormEngineConfiguration
implements SpringEngineConfiguration {
    protected PlatformTransactionManager transactionManager;
    protected String deploymentName = "SpringAutoDeployment";
    protected Resource[] deploymentResources = new Resource[0];
    protected String deploymentMode = "default";
    protected ApplicationContext applicationContext;
    protected Integer transactionSynchronizationAdapterOrder;
    private Collection<AutoDeploymentStrategy<FormEngine>> deploymentStrategies = new ArrayList<AutoDeploymentStrategy<FormEngine>>();
    protected volatile boolean running = false;
    protected List<String> enginesBuild = new ArrayList<String>();
    protected final Object lifeCycleMonitor = new Object();

    public SpringFormEngineConfiguration() {
        this.transactionsExternallyManaged = true;
        this.deploymentStrategies.add((AutoDeploymentStrategy<FormEngine>)new DefaultAutoDeploymentStrategy());
        this.deploymentStrategies.add((AutoDeploymentStrategy<FormEngine>)new SingleResourceAutoDeploymentStrategy());
        this.deploymentStrategies.add((AutoDeploymentStrategy<FormEngine>)new ResourceParentFolderAutoDeploymentStrategy());
    }

    public FormEngine buildFormEngine() {
        FormEngine formEngine = super.buildFormEngine();
        FormEngines.setInitialized((boolean)true);
        this.enginesBuild.add(formEngine.getName());
        return formEngine;
    }

    public void initBeans() {
        if (this.beans == null) {
            this.beans = new SpringBeanFactoryProxyMap((BeanFactory)this.applicationContext);
        }
    }

    public void setTransactionSynchronizationAdapterOrder(Integer transactionSynchronizationAdapterOrder) {
        this.transactionSynchronizationAdapterOrder = transactionSynchronizationAdapterOrder;
    }

    public void initDefaultCommandConfig() {
        if (this.defaultCommandConfig == null) {
            this.defaultCommandConfig = new CommandConfig().setContextReusePossible(true);
        }
    }

    public CommandInterceptor createTransactionInterceptor() {
        if (this.transactionManager == null) {
            throw new FlowableException("transactionManager is required property for SpringFormEngineConfiguration, use " + StandaloneFormEngineConfiguration.class.getName() + " otherwise");
        }
        return new SpringTransactionInterceptor(this.transactionManager);
    }

    public void initTransactionContextFactory() {
        if (this.transactionContextFactory == null && this.transactionManager != null) {
            this.transactionContextFactory = new SpringTransactionContextFactory(this.transactionManager, this.transactionSynchronizationAdapterOrder);
        }
    }

    protected void autoDeployResources(FormEngine formEngine) {
        if (this.deploymentResources != null && this.deploymentResources.length > 0) {
            AutoDeploymentStrategy<FormEngine> strategy = this.getAutoDeploymentStrategy(this.deploymentMode);
            strategy.deployResources(this.deploymentName, this.deploymentResources, (Object)formEngine);
        }
    }

    public FormEngineConfiguration setDataSource(DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            return (FormEngineConfiguration)super.setDataSource(dataSource);
        }
        TransactionAwareDataSourceProxy proxiedDataSource = new TransactionAwareDataSourceProxy(dataSource);
        return (FormEngineConfiguration)super.setDataSource((DataSource)proxiedDataSource);
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public Resource[] getDeploymentResources() {
        return this.deploymentResources;
    }

    public void setDeploymentResources(Resource[] deploymentResources) {
        this.deploymentResources = deploymentResources;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(String deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    protected AutoDeploymentStrategy<FormEngine> getAutoDeploymentStrategy(String mode) {
        AutoDeploymentStrategy<FormEngine> result = new AutoDeploymentStrategy<FormEngine>();
        for (AutoDeploymentStrategy<FormEngine> strategy : this.deploymentStrategies) {
            if (!strategy.handlesMode(mode)) continue;
            result = strategy;
            break;
        }
        return result;
    }

    public Collection<AutoDeploymentStrategy<FormEngine>> getDeploymentStrategies() {
        return this.deploymentStrategies;
    }

    public void setDeploymentStrategies(Collection<AutoDeploymentStrategy<FormEngine>> deploymentStrategies) {
        this.deploymentStrategies = deploymentStrategies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                this.enginesBuild.forEach(name -> this.autoDeployResources(FormEngines.getFormEngine((String)name)));
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return super.getPhase() - 20;
    }
}

