/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.spring;

import java.util.Map;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.spring.SpringFormEngineConfiguration;
import org.flowable.form.spring.SpringFormExpressionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FormEngineFactoryBean
implements FactoryBean<FormEngine>,
DisposableBean,
ApplicationContextAware {
    protected FormEngineConfiguration formEngineConfiguration;
    protected ApplicationContext applicationContext;
    protected FormEngine formEngine;

    public void destroy() throws Exception {
        if (this.formEngine != null) {
            this.formEngine.close();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public FormEngine getObject() throws Exception {
        this.configureExpressionManager();
        this.configureExternallyManagedTransactions();
        if (this.formEngineConfiguration.getBeans() == null) {
            this.formEngineConfiguration.setBeans((Map)new SpringBeanFactoryProxyMap((BeanFactory)this.applicationContext));
        }
        this.formEngine = this.formEngineConfiguration.buildFormEngine();
        return this.formEngine;
    }

    protected void configureExpressionManager() {
        if (this.formEngineConfiguration.getExpressionManager() == null && this.applicationContext != null) {
            this.formEngineConfiguration.setExpressionManager((ExpressionManager)new SpringFormExpressionManager(this.applicationContext, this.formEngineConfiguration.getBeans()));
        }
    }

    protected void configureExternallyManagedTransactions() {
        SpringFormEngineConfiguration engineConfiguration;
        if (this.formEngineConfiguration instanceof SpringFormEngineConfiguration && (engineConfiguration = (SpringFormEngineConfiguration)this.formEngineConfiguration).getTransactionManager() != null) {
            this.formEngineConfiguration.setTransactionsExternallyManaged(true);
        }
    }

    public Class<FormEngine> getObjectType() {
        return FormEngine.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public FormEngineConfiguration getFormEngineConfiguration() {
        return this.formEngineConfiguration;
    }

    public void setFormEngineConfiguration(FormEngineConfiguration formEngineConfiguration) {
        this.formEngineConfiguration = formEngineConfiguration;
    }
}

