/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl;

import java.util.List;
import java.util.Set;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;
import org.flowable.form.api.FormDefinition;
import org.flowable.form.api.FormDefinitionQuery;
import org.flowable.form.engine.impl.FormQueryProperty;
import org.flowable.form.engine.impl.util.CommandContextUtil;

public class FormDefinitionQueryImpl
extends AbstractQuery<FormDefinitionQuery, FormDefinition>
implements FormDefinitionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected Set<String> ids;
    protected String category;
    protected String categoryLike;
    protected String categoryNotEquals;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected Set<String> deploymentIds;
    protected String parentDeploymentId;
    protected String key;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected Integer versionGt;
    protected Integer versionGte;
    protected Integer versionLt;
    protected Integer versionLte;
    protected boolean latest;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;

    public FormDefinitionQueryImpl() {
    }

    public FormDefinitionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public FormDefinitionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public FormDefinitionQueryImpl formId(String formId) {
        this.id = formId;
        return this;
    }

    public FormDefinitionQuery formIds(Set<String> formIds) {
        this.ids = formIds;
        return this;
    }

    public FormDefinitionQueryImpl formCategory(String category) {
        if (category == null) {
            throw new FlowableIllegalArgumentException("category is null");
        }
        this.category = category;
        return this;
    }

    public FormDefinitionQueryImpl formCategoryLike(String categoryLike) {
        if (categoryLike == null) {
            throw new FlowableIllegalArgumentException("categoryLike is null");
        }
        this.categoryLike = categoryLike;
        return this;
    }

    public FormDefinitionQueryImpl formCategoryNotEquals(String categoryNotEquals) {
        if (categoryNotEquals == null) {
            throw new FlowableIllegalArgumentException("categoryNotEquals is null");
        }
        this.categoryNotEquals = categoryNotEquals;
        return this;
    }

    public FormDefinitionQueryImpl formName(String name) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("name is null");
        }
        this.name = name;
        return this;
    }

    public FormDefinitionQueryImpl formNameLike(String nameLike) {
        if (nameLike == null) {
            throw new FlowableIllegalArgumentException("nameLike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    public FormDefinitionQueryImpl deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("id is null");
        }
        this.deploymentId = deploymentId;
        return this;
    }

    public FormDefinitionQueryImpl deploymentIds(Set<String> deploymentIds) {
        if (deploymentIds == null) {
            throw new FlowableIllegalArgumentException("ids are null");
        }
        this.deploymentIds = deploymentIds;
        return this;
    }

    public FormDefinitionQueryImpl parentDeploymentId(String parentDeploymentId) {
        if (parentDeploymentId == null) {
            throw new FlowableIllegalArgumentException("parentDeploymentId is null");
        }
        this.parentDeploymentId = parentDeploymentId;
        return this;
    }

    public FormDefinitionQueryImpl formDefinitionKey(String key) {
        if (key == null) {
            throw new FlowableIllegalArgumentException("key is null");
        }
        this.key = key;
        return this;
    }

    public FormDefinitionQueryImpl formDefinitionKeyLike(String keyLike) {
        if (keyLike == null) {
            throw new FlowableIllegalArgumentException("keyLike is null");
        }
        this.keyLike = keyLike;
        return this;
    }

    public FormDefinitionQueryImpl formResourceName(String resourceName) {
        if (resourceName == null) {
            throw new FlowableIllegalArgumentException("resourceName is null");
        }
        this.resourceName = resourceName;
        return this;
    }

    public FormDefinitionQueryImpl formResourceNameLike(String resourceNameLike) {
        if (resourceNameLike == null) {
            throw new FlowableIllegalArgumentException("resourceNameLike is null");
        }
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    public FormDefinitionQueryImpl formVersion(Integer version) {
        this.checkVersion(version);
        this.version = version;
        return this;
    }

    public FormDefinitionQuery formVersionGreaterThan(Integer formVersion) {
        this.checkVersion(formVersion);
        this.versionGt = formVersion;
        return this;
    }

    public FormDefinitionQuery formVersionGreaterThanOrEquals(Integer formVersion) {
        this.checkVersion(formVersion);
        this.versionGte = formVersion;
        return this;
    }

    public FormDefinitionQuery formVersionLowerThan(Integer formVersion) {
        this.checkVersion(formVersion);
        this.versionLt = formVersion;
        return this;
    }

    public FormDefinitionQuery formVersionLowerThanOrEquals(Integer formVersion) {
        this.checkVersion(formVersion);
        this.versionLte = formVersion;
        return this;
    }

    protected void checkVersion(Integer version) {
        if (version == null) {
            throw new FlowableIllegalArgumentException("version is null");
        }
        if (version <= 0) {
            throw new FlowableIllegalArgumentException("version must be positive");
        }
    }

    public FormDefinitionQueryImpl latestVersion() {
        this.latest = true;
        return this;
    }

    public FormDefinitionQuery formTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("form tenantId is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public FormDefinitionQuery formTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("form tenantId is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public FormDefinitionQuery formWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public FormDefinitionQuery orderByDeploymentId() {
        return (FormDefinitionQuery)this.orderBy(FormQueryProperty.DEPLOYMENT_ID);
    }

    public FormDefinitionQuery orderByFormDefinitionKey() {
        return (FormDefinitionQuery)this.orderBy(FormQueryProperty.FORM_DEFINITION_KEY);
    }

    public FormDefinitionQuery orderByFormCategory() {
        return (FormDefinitionQuery)this.orderBy(FormQueryProperty.FORM_CATEGORY);
    }

    public FormDefinitionQuery orderByFormId() {
        return (FormDefinitionQuery)this.orderBy(FormQueryProperty.FORM_ID);
    }

    public FormDefinitionQuery orderByFormVersion() {
        return (FormDefinitionQuery)this.orderBy(FormQueryProperty.FORM_VERSION);
    }

    public FormDefinitionQuery orderByFormName() {
        return (FormDefinitionQuery)this.orderBy(FormQueryProperty.FORM_NAME);
    }

    public FormDefinitionQuery orderByTenantId() {
        return (FormDefinitionQuery)this.orderBy(FormQueryProperty.FORM_TENANT_ID);
    }

    public long executeCount(CommandContext commandContext) {
        return CommandContextUtil.getFormDefinitionEntityManager(commandContext).findFormDefinitionCountByQueryCriteria(this);
    }

    public List<FormDefinition> executeList(CommandContext commandContext) {
        return CommandContextUtil.getFormDefinitionEntityManager(commandContext).findFormDefinitionsByQueryCriteria(this);
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public Set<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public String getParentDeploymentId() {
        return this.parentDeploymentId;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Integer getVersionGt() {
        return this.versionGt;
    }

    public Integer getVersionGte() {
        return this.versionGte;
    }

    public Integer getVersionLt() {
        return this.versionLt;
    }

    public Integer getVersionLte() {
        return this.versionLte;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNameLike() {
        return this.resourceNameLike;
    }

    public String getCategoryNotEquals() {
        return this.categoryNotEquals;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }
}

