/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.payload;

import java.util.ArrayList;
import java.util.Collection;
import org.flowable.eventregistry.api.FlowableEventInfo;
import org.flowable.eventregistry.api.InboundEventInfoAwarePayloadExtractor;
import org.flowable.eventregistry.api.InboundEventPayloadExtractor;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.model.EventModel;

public class CompositePayloadExtractor<T>
implements InboundEventInfoAwarePayloadExtractor<T> {
    protected final Collection<InboundEventPayloadExtractor<T>> payloadExtractors;

    public CompositePayloadExtractor(Collection<InboundEventPayloadExtractor<T>> payloadExtractors) {
        this.payloadExtractors = payloadExtractors;
    }

    public Collection<EventPayloadInstance> extractPayload(EventModel eventModel, FlowableEventInfo<T> event) {
        if (this.payloadExtractors.size() == 1) {
            return this.payloadExtractors.iterator().next().extractPayload(eventModel, event);
        }
        ArrayList<EventPayloadInstance> payloadInstances = new ArrayList<EventPayloadInstance>();
        for (InboundEventPayloadExtractor<T> payloadExtractor : this.payloadExtractors) {
            payloadInstances.addAll(payloadExtractor.extractPayload(eventModel, event));
        }
        return payloadInstances;
    }
}

