/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.management;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.api.InboundChannelModelCacheManager;
import org.flowable.eventregistry.api.management.EventRegistryChangeDetectionManager;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.util.CommandContextUtil;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventRegistryChangeDetectionManager
implements EventRegistryChangeDetectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEventRegistryChangeDetectionManager.class);
    protected EventRegistryEngineConfiguration eventRegistryEngineConfiguration;

    public DefaultEventRegistryChangeDetectionManager(EventRegistryEngineConfiguration eventRegistryEngineConfiguration) {
        this.eventRegistryEngineConfiguration = eventRegistryEngineConfiguration;
    }

    public void detectChanges() {
        ChannelDefinition unregisteredChannel;
        List channelDefinitions = this.eventRegistryEngineConfiguration.getEventRepositoryService().createChannelDefinitionQuery().latestVersion().list();
        InboundChannelModelCacheManager inboundChannelModelCacheManager = this.eventRegistryEngineConfiguration.getInboundChannelModelCacheManager();
        HashSet<String> latestChannelDefinitionIds = new HashSet<String>();
        for (ChannelDefinition channelDefinition : channelDefinitions) {
            ChannelModel channelModel;
            latestChannelDefinitionIds.add(channelDefinition.getId());
            InboundChannelModelCacheManager.RegisteredChannel registeredChannel = inboundChannelModelCacheManager.findRegisteredChannel(channelDefinition);
            if (registeredChannel != null) {
                if (registeredChannel.getChannelDefinitionId().equals(channelDefinition.getId())) continue;
                if (registeredChannel.getChannelDefinitionVersion() > channelDefinition.getVersion() && (unregisteredChannel = this.eventRegistryEngineConfiguration.getDeploymentManager().removeChannelDefinitionFromCache(registeredChannel.getChannelDefinitionId())) != null) {
                    LOGGER.info("Unregistered channel definition with key {} and tenant {} from cache", (Object)unregisteredChannel.getKey(), (Object)unregisteredChannel.getTenantId());
                }
            }
            if (!((channelModel = this.eventRegistryEngineConfiguration.getEventRepositoryService().getChannelModelById(channelDefinition.getId())) instanceof InboundChannelModel)) continue;
            if (inboundChannelModelCacheManager.findRegisteredChannel(channelDefinition) == null) {
                this.eventRegistryEngineConfiguration.getCommandExecutor().execute(commandContext -> {
                    EventRegistryEngineConfiguration eventRegistryConfiguration = CommandContextUtil.getEventRegistryConfiguration(commandContext);
                    eventRegistryConfiguration.getEventDeployer().getCachingAndArtifcatsManager().registerChannelModel(channelModel, channelDefinition, this.eventRegistryEngineConfiguration);
                    return null;
                });
            }
            LOGGER.info("Deployed channel definition with key {} and tenant {}", (Object)channelDefinition.getKey(), (Object)channelDefinition.getTenantId());
        }
        Collection registeredChannels = inboundChannelModelCacheManager.getRegisteredChannels();
        for (InboundChannelModelCacheManager.RegisteredChannel registeredChannel : registeredChannels) {
            if (latestChannelDefinitionIds.contains(registeredChannel.getChannelDefinitionId()) || (unregisteredChannel = this.eventRegistryEngineConfiguration.getDeploymentManager().removeChannelDefinitionFromCache(registeredChannel.getChannelDefinitionId())) == null) continue;
            LOGGER.info("Unregistered channel definition with key {} and tenant {} from cache", (Object)unregisteredChannel.getKey(), (Object)unregisteredChannel.getTenantId());
        }
    }
}

