/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.impl.EventDeploymentQueryImpl;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.persistence.deploy.ChannelDefinitionCacheEntry;
import org.flowable.eventregistry.impl.persistence.deploy.EventDeploymentManager;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntityManager;
import org.flowable.eventregistry.impl.util.CommandContextUtil;
import org.flowable.eventregistry.model.ChannelModel;

public class GetChannelModelCmd
implements Command<ChannelModel>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String channelDefinitionKey;
    protected String channelDefinitionId;
    protected String tenantId;
    protected String parentDeploymentId;

    public GetChannelModelCmd(String channelDefinitionKey, String channelDefinitionId) {
        this.channelDefinitionKey = channelDefinitionKey;
        this.channelDefinitionId = channelDefinitionId;
    }

    public GetChannelModelCmd(String channelDefinitionKey, String tenantId, String parentDeploymentId) {
        this(channelDefinitionKey, null);
        this.tenantId = tenantId;
        this.parentDeploymentId = parentDeploymentId;
    }

    public ChannelModel execute(CommandContext commandContext) {
        List<EventDeployment> eventDeployments;
        EventRegistryEngineConfiguration eventEngineConfiguration = CommandContextUtil.getEventRegistryConfiguration(commandContext);
        EventDeploymentManager deploymentManager = eventEngineConfiguration.getDeploymentManager();
        ChannelDefinitionEntityManager channelDefinitionEntityManager = eventEngineConfiguration.getChannelDefinitionEntityManager();
        ChannelDefinitionEntity channelDefinitionEntity = null;
        if (this.channelDefinitionId != null) {
            channelDefinitionEntity = deploymentManager.findDeployedChannelDefinitionById(this.channelDefinitionId);
            if (channelDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No channel definition found for id = '" + this.channelDefinitionId + "'", ChannelDefinitionEntity.class);
            }
        } else if (this.channelDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && (this.parentDeploymentId == null || eventEngineConfiguration.isAlwaysLookupLatestDefinitionVersion())) {
            channelDefinitionEntity = deploymentManager.findDeployedLatestChannelDefinitionByKey(this.channelDefinitionKey);
            if (channelDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No channel definition found for key '" + this.channelDefinitionKey + "'", ChannelDefinitionEntity.class);
            }
        } else if (this.channelDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && (this.parentDeploymentId == null || eventEngineConfiguration.isAlwaysLookupLatestDefinitionVersion())) {
            channelDefinitionEntity = channelDefinitionEntityManager.findLatestChannelDefinitionByKeyAndTenantId(this.channelDefinitionKey, this.tenantId);
            if (channelDefinitionEntity == null && eventEngineConfiguration.isFallbackToDefaultTenant()) {
                String defaultTenant = eventEngineConfiguration.getDefaultTenantProvider().getDefaultTenant(this.tenantId, "eventRegistry", this.channelDefinitionKey);
                channelDefinitionEntity = StringUtils.isNotEmpty((CharSequence)defaultTenant) ? channelDefinitionEntityManager.findLatestChannelDefinitionByKeyAndTenantId(this.channelDefinitionKey, defaultTenant) : channelDefinitionEntityManager.findLatestChannelDefinitionByKey(this.channelDefinitionKey);
            }
            if (channelDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No channel definition found for key '" + this.channelDefinitionKey + "' for tenant identifier " + this.tenantId, ChannelDefinitionEntity.class);
            }
        } else if (this.channelDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId != null) {
            eventDeployments = deploymentManager.getDeploymentEntityManager().findDeploymentsByQueryCriteria(new EventDeploymentQueryImpl().parentDeploymentId(this.parentDeploymentId));
            if (eventDeployments != null && eventDeployments.size() > 0) {
                channelDefinitionEntity = channelDefinitionEntityManager.findChannelDefinitionByDeploymentAndKey(eventDeployments.get(0).getId(), this.channelDefinitionKey);
            }
            if (channelDefinitionEntity == null) {
                channelDefinitionEntity = channelDefinitionEntityManager.findLatestChannelDefinitionByKey(this.channelDefinitionKey);
            }
            if (channelDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No channel definition found for key '" + this.channelDefinitionKey + "' for parent deployment id " + this.parentDeploymentId, ChannelDefinitionEntity.class);
            }
        } else if (this.channelDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId != null) {
            eventDeployments = deploymentManager.getDeploymentEntityManager().findDeploymentsByQueryCriteria(new EventDeploymentQueryImpl().parentDeploymentId(this.parentDeploymentId).deploymentTenantId(this.tenantId));
            if (eventDeployments != null && eventDeployments.size() > 0) {
                channelDefinitionEntity = channelDefinitionEntityManager.findChannelDefinitionByDeploymentAndKeyAndTenantId(eventDeployments.get(0).getId(), this.channelDefinitionKey, this.tenantId);
            }
            if (channelDefinitionEntity == null) {
                channelDefinitionEntity = channelDefinitionEntityManager.findLatestChannelDefinitionByKeyAndTenantId(this.channelDefinitionKey, this.tenantId);
            }
            if (channelDefinitionEntity == null && eventEngineConfiguration.isFallbackToDefaultTenant()) {
                String defaultTenant = eventEngineConfiguration.getDefaultTenantProvider().getDefaultTenant(this.tenantId, "eventRegistry", this.channelDefinitionKey);
                channelDefinitionEntity = StringUtils.isNotEmpty((CharSequence)defaultTenant) ? channelDefinitionEntityManager.findLatestChannelDefinitionByKeyAndTenantId(this.channelDefinitionKey, defaultTenant) : channelDefinitionEntityManager.findLatestChannelDefinitionByKey(this.channelDefinitionKey);
            }
            if (channelDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No channel definition found for key '" + this.channelDefinitionKey + " for parent deployment id '" + this.parentDeploymentId + "' and for tenant identifier " + this.tenantId, ChannelDefinitionEntity.class);
            }
        } else {
            throw new FlowableObjectNotFoundException("channelDefinitionKey and channelDefinitionId are null");
        }
        ChannelDefinitionCacheEntry channelDefinitionCacheEntry = deploymentManager.resolveChannelDefinition(channelDefinitionEntity);
        return channelDefinitionCacheEntry.getChannelModel();
    }
}

