/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.rest.service.api.repository.BaseEventDefinitionResource;
import org.flowable.eventregistry.rest.service.api.repository.ChannelDefinitionResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Channel Definitions"}, description="Manage Channel Definitions", authorizations={@Authorization(value="basicAuth")})
public class ChannelDefinitionResource
extends BaseEventDefinitionResource {
    @Autowired
    protected EventRegistryEngineConfiguration eventRegistryEngineConfiguration;
    @Autowired(required=false)
    protected EventRepositoryService eventRepositoryService;

    @ApiOperation(value="Get a channel definition", tags={"Case Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the channel definitions are returned"), @ApiResponse(code=404, message="Indicates the requested event definition was not found.")})
    @GetMapping(value={"/event-registry-repository/channel-definitions/{channelDefinitionId}"}, produces={"application/json"})
    public ChannelDefinitionResponse getChannelDefinition(@ApiParam(name="channelDefinitionId") @PathVariable String channelDefinitionId, HttpServletRequest request) {
        ChannelDefinition channelDefinition = this.getChannelDefinitionFromRequest(channelDefinitionId);
        return this.restResponseFactory.createChannelDefinitionResponse(channelDefinition);
    }
}

