/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.repository;

import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.api.EventDefinition;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.rest.service.api.EventRegistryRestApiInterceptor;
import org.flowable.eventregistry.rest.service.api.EventRegistryRestResponseFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseEventDefinitionResource {
    @Autowired
    protected EventRegistryRestResponseFactory restResponseFactory;
    @Autowired
    protected EventRepositoryService repositoryService;
    @Autowired(required=false)
    protected EventRegistryRestApiInterceptor restApiInterceptor;

    protected EventDefinition getEventDefinitionFromRequest(String eventDefinitionId) {
        EventDefinition eventDefinition = this.repositoryService.getEventDefinition(eventDefinitionId);
        if (eventDefinition == null) {
            throw new FlowableObjectNotFoundException("Could not find an event definition with id '" + eventDefinitionId + "'.", EventDefinition.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessEventDefinitionById(eventDefinition);
        }
        return eventDefinition;
    }

    protected ChannelDefinition getChannelDefinitionFromRequest(String channelDefinitionId) {
        ChannelDefinition channelDefinition = this.repositoryService.getChannelDefinition(channelDefinitionId);
        if (channelDefinition == null) {
            throw new FlowableObjectNotFoundException("Could not find a channel definition with id '" + channelDefinitionId + "'.", ChannelDefinition.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessChannelDefinitionById(channelDefinition);
        }
        return channelDefinition;
    }
}

