/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.eventregistry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.common.engine.api.lock.LockManager;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceBuilder;
import org.flowable.engine.runtime.ProcessInstanceQuery;
import org.flowable.eventregistry.api.EventConsumerInfo;
import org.flowable.eventregistry.api.EventRegistryProcessingInfo;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.impl.consumer.BaseEventRegistryEventConsumer;
import org.flowable.eventregistry.impl.consumer.CorrelationKey;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.api.EventSubscriptionQuery;
import org.flowable.eventsubscription.service.impl.EventSubscriptionQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnEventRegistryEventConsumer
extends BaseEventRegistryEventConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmnEventRegistryEventConsumer.class);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public BpmnEventRegistryEventConsumer(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super((AbstractEngineConfiguration)processEngineConfiguration);
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public String getConsumerKey() {
        return "bpmnEventConsumer";
    }

    protected EventRegistryProcessingInfo eventReceived(EventInstance eventInstance) {
        EventRegistryProcessingInfo eventRegistryProcessingInfo = new EventRegistryProcessingInfo();
        Collection correlationKeys = this.generateCorrelationKeys(eventInstance.getCorrelationParameterInstances());
        List eventSubscriptions = this.findEventSubscriptions("bpmn", eventInstance, correlationKeys);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found {} for {}", (Object)eventSubscriptions, (Object)eventInstance);
        }
        RuntimeService runtimeService = this.processEngineConfiguration.getRuntimeService();
        for (EventSubscription eventSubscription : eventSubscriptions) {
            EventConsumerInfo eventConsumerInfo = new EventConsumerInfo(eventSubscription.getId(), eventSubscription.getExecutionId(), eventSubscription.getProcessDefinitionId(), "bpmn");
            this.handleEventSubscription(runtimeService, eventSubscription, eventInstance, correlationKeys, eventConsumerInfo);
            eventRegistryProcessingInfo.addEventConsumerInfo(eventConsumerInfo);
        }
        return eventRegistryProcessingInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEventSubscription(RuntimeService runtimeService, EventSubscription eventSubscription, EventInstance eventInstance, Collection<CorrelationKey> correlationKeys, EventConsumerInfo eventConsumerInfo) {
        String executionId = eventSubscription.getExecutionId();
        if (executionId != null) {
            HashMap<String, Object> transientVariableMap = new HashMap<String, Object>();
            transientVariableMap.put("eventInstance", eventInstance);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Triggering execution {} with {}", (Object)executionId, (Object)eventInstance);
            }
            runtimeService.trigger(executionId, null, transientVariableMap);
        } else if (eventSubscription.getProcessDefinitionId() != null && eventSubscription.getProcessInstanceId() == null) {
            String startCorrelationConfiguration;
            if (correlationKeys != null && Objects.equals(startCorrelationConfiguration = this.getStartCorrelationConfiguration(eventSubscription), "storeAsUniqueReferenceId")) {
                ProcessDefinition processDefinition;
                CorrelationKey correlationKeyWithAllParameters = this.getCorrelationKeyWithAllParameters(correlationKeys, eventInstance);
                long processInstanceCount = this.countProcessInstances(runtimeService, eventInstance, correlationKeyWithAllParameters, processDefinition = this.processEngineConfiguration.getRepositoryService().getProcessDefinition(eventSubscription.getProcessDefinitionId()));
                if (processInstanceCount > 0L) {
                    eventConsumerInfo.setHasExistingInstancesForUniqueCorrelation(true);
                    LOGGER.debug("Event received to start a new process instance, but a unique instance already exists.");
                    return;
                }
                if (this.processEngineConfiguration.isEventRegistryUniqueProcessInstanceCheckWithLock()) {
                    String countLockName = "belock" + correlationKeyWithAllParameters.getValue() + processDefinition.getKey();
                    LockManager lockManager = this.processEngineConfiguration.getManagementService().getLockManager(countLockName);
                    boolean lockAcquired = lockManager.acquireLock(this.processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionLockTime());
                    if (lockAcquired) {
                        try {
                            processInstanceCount = this.countProcessInstances(runtimeService, eventInstance, correlationKeyWithAllParameters, processDefinition);
                            if (processInstanceCount > 0L) {
                                eventConsumerInfo.setHasExistingInstancesForUniqueCorrelation(true);
                                LOGGER.debug("Event received to start a new process instance, but a unique instance already exists.");
                                return;
                            }
                            this.startProcessInstance(runtimeService, eventSubscription, eventInstance, correlationKeyWithAllParameters);
                            return;
                        }
                        finally {
                            lockManager.releaseLock();
                        }
                    }
                    LOGGER.info("Lock for {} was not acquired. This means that another event has already acquired that lock and will start a new process instance. Ignoring this one.", (Object)countLockName);
                    return;
                }
                this.startProcessInstance(runtimeService, eventSubscription, eventInstance, correlationKeyWithAllParameters);
                return;
            }
            this.startProcessInstance(runtimeService, eventSubscription, eventInstance, null);
        } else {
            LOGGER.warn("Ignoring {}. It was acquired by the bpmn event consumer, but it is not used", (Object)eventSubscription);
        }
    }

    protected long countProcessInstances(RuntimeService runtimeService, EventInstance eventInstance, CorrelationKey correlationKey, ProcessDefinition processDefinition) {
        ProcessInstanceQuery processInstanceQuery = runtimeService.createProcessInstanceQuery().processDefinitionKey(processDefinition.getKey()).processInstanceReferenceId(correlationKey.getValue()).processInstanceReferenceType("event-to-bpmn-2.0-process");
        if (eventInstance.getTenantId() != null && !Objects.equals("", eventInstance.getTenantId())) {
            processInstanceQuery.processInstanceTenantId(eventInstance.getTenantId());
        }
        return processInstanceQuery.count();
    }

    protected void startProcessInstance(RuntimeService runtimeService, EventSubscription eventSubscription, EventInstance eventInstance, CorrelationKey correlationKey) {
        ProcessInstanceBuilder processInstanceBuilder = runtimeService.createProcessInstanceBuilder().processDefinitionId(eventSubscription.getProcessDefinitionId()).transientVariable("eventInstance", eventInstance);
        if (StringUtils.isNotEmpty((CharSequence)eventSubscription.getActivityId())) {
            processInstanceBuilder.startEventId(eventSubscription.getActivityId());
        }
        if (eventInstance.getTenantId() != null && !Objects.equals("", eventInstance.getTenantId())) {
            processInstanceBuilder.overrideProcessDefinitionTenantId(eventInstance.getTenantId());
        }
        if (correlationKey != null) {
            processInstanceBuilder.referenceId(correlationKey.getValue()).referenceType("event-to-bpmn-2.0-process");
        }
        boolean debugLoggingEnabled = LOGGER.isDebugEnabled();
        if (this.processEngineConfiguration.isEventRegistryStartProcessInstanceAsync()) {
            if (debugLoggingEnabled) {
                LOGGER.debug("Async starting process instance for {} with {}", (Object)eventSubscription, (Object)eventInstance);
            }
            ProcessInstance processInstance = processInstanceBuilder.startAsync();
            if (debugLoggingEnabled) {
                LOGGER.debug("Started {} async for {} with {}", new Object[]{processInstance, eventSubscription, eventInstance});
            }
        } else {
            if (debugLoggingEnabled) {
                LOGGER.debug("Starting process instance for {} with {}", (Object)eventSubscription, (Object)eventInstance);
            }
            ProcessInstance processInstance = processInstanceBuilder.start();
            if (debugLoggingEnabled) {
                LOGGER.debug("Started {} for {} with {}", new Object[]{processInstance, eventSubscription, eventInstance});
            }
        }
    }

    protected String getStartCorrelationConfiguration(EventSubscription eventSubscription) {
        BpmnModel bpmnModel = this.processEngineConfiguration.getRepositoryService().getBpmnModel(eventSubscription.getProcessDefinitionId());
        if (bpmnModel != null) {
            List startEvents = bpmnModel.getMainProcess().findFlowElementsOfType(StartEvent.class);
            for (StartEvent startEvent : startEvents) {
                List correlationCfgExtensions;
                List eventTypes = (List)startEvent.getExtensionElements().get("eventType");
                if (eventTypes == null || eventTypes.isEmpty() || !Objects.equals(eventSubscription.getEventType(), ((ExtensionElement)eventTypes.get(0)).getElementText()) || (correlationCfgExtensions = startEvent.getExtensionElements().getOrDefault("startEventCorrelationConfiguration", Collections.emptyList())).isEmpty()) continue;
                return ((ExtensionElement)correlationCfgExtensions.get(0)).getElementText();
            }
        }
        return null;
    }

    protected EventSubscriptionQuery createEventSubscriptionQuery() {
        return new EventSubscriptionQueryImpl(this.commandExecutor, this.processEngineConfiguration.getEventSubscriptionServiceConfiguration());
    }
}

