/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CancelEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ScopeUtil;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;

public class CancelEndEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(DelegateExecution execution) {
        SubProcess subProcess;
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        DelegateExecution parentScopeExecution = null;
        ExecutionEntity currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(executionEntity.getParentId());
        while (currentlyExaminedExecution != null && parentScopeExecution == null) {
            if (currentlyExaminedExecution.getCurrentFlowElement() instanceof SubProcess) {
                ExecutionEntity miExecution;
                FlowElement miElement;
                parentScopeExecution = currentlyExaminedExecution;
                subProcess = (SubProcess)currentlyExaminedExecution.getCurrentFlowElement();
                if (subProcess.getLoopCharacteristics() == null || (miElement = (miExecution = parentScopeExecution.getParent()).getCurrentFlowElement()) == null || !miElement.getId().equals(subProcess.getId())) continue;
                parentScopeExecution = miExecution;
                continue;
            }
            currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(currentlyExaminedExecution.getParentId());
        }
        if (parentScopeExecution == null) {
            throw new FlowableException("No sub process execution found for cancel end event in " + executionEntity);
        }
        subProcess = (SubProcess)parentScopeExecution.getCurrentFlowElement();
        BoundaryEvent cancelBoundaryEvent = null;
        if (CollectionUtil.isNotEmpty((Collection)subProcess.getBoundaryEvents())) {
            for (BoundaryEvent boundaryEvent : subProcess.getBoundaryEvents()) {
                if (!CollectionUtil.isNotEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CancelEventDefinition)) continue;
                cancelBoundaryEvent = boundaryEvent;
                break;
            }
        }
        if (cancelBoundaryEvent == null) {
            throw new FlowableException("Could not find cancel boundary event for cancel end event in " + executionEntity);
        }
        ExecutionEntity newParentScopeExecution = null;
        currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(parentScopeExecution.getParentId());
        while (currentlyExaminedExecution != null && newParentScopeExecution == null) {
            if (currentlyExaminedExecution.isScope()) {
                newParentScopeExecution = currentlyExaminedExecution;
                continue;
            }
            currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(currentlyExaminedExecution.getParentId());
        }
        if (newParentScopeExecution == null) {
            throw new FlowableException("Programmatic error: no parent scope execution found for boundary event " + cancelBoundaryEvent.getId() + " for " + (ExecutionEntity)parentScopeExecution);
        }
        ScopeUtil.createCopyOfSubProcessExecutionForCompensation((ExecutionEntity)parentScopeExecution);
        if (subProcess.getLoopCharacteristics() != null) {
            List<? extends ExecutionEntity> multiInstanceExecutions = parentScopeExecution.getExecutions();
            ArrayList<ExecutionEntity> executionsToDelete = new ArrayList<ExecutionEntity>();
            for (ExecutionEntity executionEntity2 : multiInstanceExecutions) {
                if (executionEntity2.getId().equals(parentScopeExecution.getId())) continue;
                ScopeUtil.createCopyOfSubProcessExecutionForCompensation(executionEntity2);
                executionsToDelete.add(executionEntity2);
                this.deleteChildExecutions(executionEntity2, executionEntity, commandContext, "transaction canceled");
            }
            for (ExecutionEntity executionEntity3 : executionsToDelete) {
                this.deleteChildExecutions(executionEntity3, executionEntity, commandContext, "transaction canceled");
            }
        }
        CommandContextUtil.getActivityInstanceEntityManager(commandContext).recordActivityEnd(executionEntity, null);
        executionEntity.setParent(newParentScopeExecution);
        executionEntity.setCurrentFlowElement((FlowElement)cancelBoundaryEvent);
        this.deleteChildExecutions((ExecutionEntity)parentScopeExecution, executionEntity, commandContext, "transaction canceled");
        CommandContextUtil.getAgenda(commandContext).planTriggerExecutionOperation(executionEntity);
    }

    protected void deleteChildExecutions(ExecutionEntity parentExecution, ExecutionEntity notToDeleteExecution, CommandContext commandContext, String deleteReason) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(parentExecution.getId());
        if (CollectionUtil.isNotEmpty(childExecutions)) {
            for (ExecutionEntity childExecution : childExecutions) {
                if (childExecution.getId().equals(notToDeleteExecution.getId())) continue;
                this.deleteChildExecutions(childExecution, notToDeleteExecution, commandContext, deleteReason);
            }
        }
        executionEntityManager.deleteExecutionAndRelatedData(parentExecution, deleteReason, false);
    }
}

