/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.variable.service.HistoricVariableService;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;

public class VariableRemovedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    public VariableRemovedHistoryJsonTransformer(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public List<String> getTypes() {
        return Collections.singletonList("variable-removed");
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return this.processEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService().getHistoricVariableInstance(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id")) != null;
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricVariableService historicVariableService = this.processEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService();
        HistoricVariableInstanceEntity historicVariable = historicVariableService.getHistoricVariableInstance(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id"));
        if (historicVariable != null) {
            historicVariableService.deleteHistoricVariableInstance(historicVariable);
        }
    }
}

