/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;

public class TaskCreatedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    public List<String> getTypes() {
        return Collections.singletonList("task-created");
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return true;
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricActivityInstanceEntity historicActivityInstanceEntity;
        String activityId;
        HistoricTaskService historicTaskService = CommandContextUtil.getHistoricTaskService();
        String taskId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id");
        String executionId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId");
        HistoricTaskInstanceEntity historicTaskInstance = historicTaskService.getHistoricTask(taskId);
        if (historicTaskInstance == null) {
            historicTaskInstance = historicTaskService.createHistoricTask();
            historicTaskInstance.setId(taskId);
            historicTaskInstance.setProcessDefinitionId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processDefinitionId"));
            historicTaskInstance.setProcessInstanceId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processInstanceId"));
            historicTaskInstance.setExecutionId(executionId);
            historicTaskInstance.setName(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"name"));
            historicTaskInstance.setParentTaskId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"parentTaskId"));
            historicTaskInstance.setDescription(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"description"));
            historicTaskInstance.setOwner(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"owner"));
            historicTaskInstance.setAssignee(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"assignee"));
            if (historicalData.has("createTime")) {
                historicTaskInstance.setCreateTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"createTime"));
            } else {
                historicTaskInstance.setCreateTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"startTime"));
            }
            historicTaskInstance.setTaskDefinitionKey(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"taskDefinitionKey"));
            historicTaskInstance.setTaskDefinitionId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"taskDefinitionId"));
            historicTaskInstance.setPriority(AsyncHistoryJsonUtil.getIntegerFromJson((ObjectNode)historicalData, (String)"priority").intValue());
            historicTaskInstance.setDueDate(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"dueDate"));
            historicTaskInstance.setCategory(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"category"));
            historicTaskInstance.setTenantId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"tenantId"));
            historicTaskInstance.setLastUpdateTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"__timeStamp"));
            historicTaskService.insertHistoricTask(historicTaskInstance, true);
        }
        if (StringUtils.isNotEmpty((CharSequence)executionId) && StringUtils.isNotEmpty((CharSequence)(activityId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId"))) && (historicActivityInstanceEntity = this.findHistoricActivityInstance(commandContext, executionId, activityId)) != null) {
            historicActivityInstanceEntity.setTaskId(taskId);
        }
    }
}

