/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.variable;

import org.flowable.engine.impl.variable.ValueFields;
import org.flowable.engine.impl.variable.VariableType;

public class LongType
implements VariableType {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTypeName() {
        return "long";
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        return valueFields.getLongValue();
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        valueFields.setLongValue((Long)value);
        if (value != null) {
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setTextValue(null);
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Long.class.isAssignableFrom(value.getClass()) || Long.TYPE.isAssignableFrom(value.getClass());
    }
}

